/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.registry;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContextTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestContextTestCase.class);

    @Test
    public void testSetExceptionPayloadAcrossThreads() throws InterruptedException, MuleException {
        this.runThread(this.testEvent(), false);
        this.runThread(this.testEvent(), true);
    }

    @Test
    public void testFailureWithoutThreadSafeEvent() throws InterruptedException, MuleException {
        this.runThread(this.testEvent(), false);
        this.runThread(this.testEvent(), true);
    }

    protected void runThread(Event event, boolean doTest) throws InterruptedException {
        AtomicBoolean success = new AtomicBoolean(false);
        Thread thread = new Thread(new SetExceptionPayload(event, success));
        thread.start();
        thread.join();
        if (doTest) {
            Assert.assertEquals((Object)true, (Object)success.get());
        }
    }

    private class SetExceptionPayload
    implements Runnable {
        private Event event;
        private AtomicBoolean success;

        public SetExceptionPayload(Event event, AtomicBoolean success) {
            this.event = event;
            this.success = success;
        }

        @Override
        public void run() {
            try {
                Exception exception = new Exception();
                this.event = Event.builder((Event)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)exception)).build()).error(MuleTestUtils.createErrorMock((Exception)exception)).build();
                Event.setCurrentEvent((Event)this.event);
                this.success.set(true);
            }
            catch (RuntimeException e) {
                LOGGER.error("error in thread", (Throwable)e);
            }
        }
    }
}

