/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.registry;

import java.io.FilterInputStream;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.simple.InputStreamToByteArray;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TransformerCachingTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testCacheUpdate() throws Exception {
        DataType sourceType = DataType.fromType(FilterInputStream.class);
        Transformer trans = muleContext.getRegistry().lookupTransformer(sourceType, DataType.BYTE_ARRAY);
        Assert.assertNotNull((Object)trans);
        Assert.assertTrue((boolean)(trans instanceof InputStreamToByteArray));
        FilterInputStreamToByteArray trans2 = new FilterInputStreamToByteArray();
        muleContext.getRegistry().registerTransformer((Transformer)trans2);
        trans = muleContext.getRegistry().lookupTransformer(sourceType, DataType.BYTE_ARRAY);
        Assert.assertNotNull((Object)trans);
        Assert.assertTrue((boolean)(trans instanceof FilterInputStreamToByteArray));
        trans = muleContext.getRegistry().lookupTransformer(DataType.INPUT_STREAM, DataType.BYTE_ARRAY);
        Assert.assertNotNull((Object)trans);
        Assert.assertTrue((boolean)(trans instanceof InputStreamToByteArray));
        muleContext.getRegistry().unregisterTransformer(trans2.getName());
        trans = muleContext.getRegistry().lookupTransformer(sourceType, DataType.BYTE_ARRAY);
        Assert.assertNotNull((Object)trans);
        Assert.assertTrue((boolean)(trans instanceof InputStreamToByteArray));
    }

    public static class FilterInputStreamToByteArray
    extends AbstractTransformer
    implements DiscoverableTransformer {
        public FilterInputStreamToByteArray() {
            this.registerSourceType(DataType.fromType(FilterInputStream.class));
            this.setReturnDataType(DataType.BYTE_ARRAY);
        }

        protected Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
            throw new UnsupportedOperationException("This is a transformer only to be used for testing");
        }

        public int getPriorityWeighting() {
            return 0;
        }

        public void setPriorityWeighting(int weighting) {
        }
    }
}

