/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.AbstractSplitter;
import org.mule.runtime.core.routing.MessageFilter;
import org.mule.runtime.core.routing.filters.AcceptAllFilter;
import org.mule.runtime.core.routing.filters.logic.NotFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;

public class AbstractSplitterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void simpleSplitter() throws Exception {
        TestSplitter splitter = new TestSplitter();
        MultipleEventSensingMessageProcessor listener = new MultipleEventSensingMessageProcessor();
        splitter.setListener(listener);
        splitter.setMuleContext(muleContext);
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        fruitBowl.addFruit((Fruit)banana);
        fruitBowl.addFruit((Fruit)orange);
        Event inEvent = AbstractSplitterTestCase.eventBuilder().message(Message.of((Object)fruitBowl)).build();
        Event resultEvent = splitter.process(inEvent);
        Assert.assertEquals((long)3L, (long)listener.events.size());
        Assert.assertTrue((boolean)(listener.events.get(0).getMessage().getPayload().getValue() instanceof Fruit));
        Assert.assertTrue((boolean)(listener.events.get(1).getMessage().getPayload().getValue() instanceof Fruit));
        Assert.assertTrue((boolean)(listener.events.get(2).getMessage().getPayload().getValue() instanceof Fruit));
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(List.class));
        Assert.assertEquals((long)3L, (long)((List)resultEvent.getMessage().getPayload().getValue()).size());
        Assert.assertTrue((boolean)(((InternalMessage)((List)resultEvent.getMessage().getPayload().getValue()).get(0)).getPayload().getValue() instanceof Fruit));
        Assert.assertTrue((boolean)(((InternalMessage)((List)resultEvent.getMessage().getPayload().getValue()).get(1)).getPayload().getValue() instanceof Fruit));
        Assert.assertTrue((boolean)(((InternalMessage)((List)resultEvent.getMessage().getPayload().getValue()).get(2)).getPayload().getValue() instanceof Fruit));
    }

    @Test
    public void allFilteredSplitter() throws Exception {
        TestSplitter splitter = new TestSplitter();
        splitter.setListener((Processor)new MessageFilter((Filter)new NotFilter((Filter)new AcceptAllFilter())));
        splitter.setMuleContext(muleContext);
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        fruitBowl.addFruit((Fruit)banana);
        fruitBowl.addFruit((Fruit)orange);
        Event inEvent = AbstractSplitterTestCase.eventBuilder().message(Message.of((Object)fruitBowl)).build();
        Event resultEvent = splitter.process(inEvent);
        Assert.assertThat((Object)resultEvent, (Matcher)CoreMatchers.nullValue());
    }

    private static class TestSplitter
    extends AbstractSplitter {
        private TestSplitter() {
        }

        protected List<Event> splitMessage(Event event) {
            FruitBowl bowl = (FruitBowl)event.getMessage().getPayload().getValue();
            ArrayList<Event> parts = new ArrayList<Event>();
            for (Fruit fruit : bowl.getFruit()) {
                parts.add(Event.builder((Event)event).message(Message.of((Object)fruit)).build());
            }
            return parts;
        }
    }

    private static class MultipleEventSensingMessageProcessor
    implements Processor {
        List<Event> events = new ArrayList<Event>();

        private MultipleEventSensingMessageProcessor() {
        }

        public Event process(Event event) throws MuleException {
            this.events.add(event);
            return event;
        }
    }
}

