/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.Iterator;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.routing.AbstractAggregator;
import org.mule.runtime.core.routing.AggregationException;
import org.mule.runtime.core.routing.EventGroup;
import org.mule.runtime.core.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class AggregatorTestCase
extends AbstractMuleContextTestCase {
    public AggregatorTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageAggregator() throws Exception {
        Flow flow = AggregatorTestCase.getTestFlowWithComponent((String)"test", Apple.class);
        DefaultMuleSession session = new DefaultMuleSession();
        TestEventAggregator router = new TestEventAggregator(3);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        EventContext context = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        Event event1 = Event.builder((EventContext)context).message(message1).flow((FlowConstruct)flow).session((MuleSession)session).build();
        Event event2 = Event.builder((EventContext)context).message(message2).flow((FlowConstruct)flow).session((MuleSession)session).build();
        Event event3 = Event.builder((EventContext)context).message(message3).flow((FlowConstruct)flow).session((MuleSession)session).build();
        Assert.assertNull((Object)router.process(event1));
        Assert.assertNull((Object)router.process(event2));
        Event result = router.process(event3);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getMessageAsString(muleContext).contains("test event A"));
        Assert.assertTrue((boolean)result.getMessageAsString(muleContext).contains("test event B"));
        Assert.assertTrue((boolean)result.getMessageAsString(muleContext).contains("test event C"));
        Assert.assertTrue((boolean)result.getMessageAsString(muleContext).matches("test event [A,B,C] test event [A,B,C] test event [A,B,C] "));
    }

    public static class TestEventAggregator
    extends AbstractAggregator {
        protected final int eventThreshold;
        protected int eventCount = 0;

        public TestEventAggregator(int eventThreshold) {
            this.eventThreshold = eventThreshold;
        }

        protected EventCorrelatorCallback getCorrelatorCallback(final MuleContext muleContext) {
            return new EventCorrelatorCallback(){

                public boolean shouldAggregateEvents(EventGroup events) {
                    ++eventCount;
                    if (eventCount == eventThreshold) {
                        eventCount = 0;
                        return true;
                    }
                    return false;
                }

                public EventGroup createEventGroup(Event event, Object groupId) {
                    return new EventGroup(groupId, muleContext, Optional.of(eventThreshold), storePrefix);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Event aggregateEvents(EventGroup events) throws AggregationException {
                    if (events.size() != eventThreshold) {
                        throw new IllegalStateException("eventThreshold not yet reached?");
                    }
                    StringBuilder newPayload = new StringBuilder(80);
                    try {
                        Iterator iterator = events.iterator(false);
                        while (iterator.hasNext()) {
                            Event event = (Event)iterator.next();
                            try {
                                newPayload.append(event.getMessageAsString(muleContext)).append(" ");
                            }
                            catch (MuleException e) {
                                throw new AggregationException(events, next, (Throwable)e);
                                return Event.builder((Event)events.getMessageCollectionEvent()).message(Message.of((Object)newPayload.toString())).build();
                            }
                        }
                    }
                    catch (ObjectStoreException e) {
                        throw new AggregationException(events, next, (Throwable)e);
                    }
                }
            };
        }
    }
}

