/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.retry.RetryPolicyExhaustedException;
import org.mule.runtime.core.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.runtime.core.routing.UntilSuccessfulConfiguration;
import org.mule.runtime.core.routing.filters.ExpressionFilter;
import org.mule.runtime.core.util.store.SimpleMemoryObjectStore;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class AsynchronousUntilSuccessfulProcessingStrategyTestCase
extends AbstractMuleTestCase {
    private static final String EXPECTED_FAILURE_MSG = "expected failure";
    private static final int DEFAULT_RETRIES = 4;
    private static final int DEFAULT_TRIES = 5;
    private final Latch exceptionHandlingLatch = new Latch();
    private UntilSuccessfulConfiguration mockUntilSuccessfulConfiguration = (UntilSuccessfulConfiguration)Mockito.mock(UntilSuccessfulConfiguration.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private FlowConstruct mockFlow = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Event event;
    private Processor mockRoute = (Processor)Mockito.mock(Processor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ExpressionFilter mockAlwaysTrueFailureExpressionFilter = (ExpressionFilter)Mockito.mock(ExpressionFilter.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ThreadPoolExecutor mockPool = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ScheduledThreadPoolExecutor mockScheduledPool = (ScheduledThreadPoolExecutor)Mockito.mock(ScheduledThreadPoolExecutor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private SimpleMemoryObjectStore<Event> objectStore = new SimpleMemoryObjectStore();
    private Processor mockDLQ = (Processor)Mockito.mock(Processor.class);
    private FailCallback failRoute = () -> {};
    private CountDownLatch routeCountDownLatch;
    private MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    @Mock
    private TransformationService transformationService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.mockAlwaysTrueFailureExpressionFilter.accept((Event)Matchers.any(Event.class), (Event.Builder)Matchers.any(Event.Builder.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getRoute()).thenReturn((Object)this.mockRoute);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMaxRetries()).thenReturn((Object)4);
        Message mockMessage = Message.of((Object)"");
        this.event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.mockFlow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(mockMessage).build();
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.objectStore);
        this.objectStore.clear();
        this.configureMockPoolToInvokeRunnableInNewThread();
        this.configureMockScheduledPoolToInvokeRunnableInNewThread();
        this.configureMockRouteToCountDownRouteLatch();
        this.configureExceptionStrategyToReleaseLatchWhenExecuted();
        this.configureDLQToReleaseLatchWhenExecuted();
        Mockito.when((Object)this.muleContext.getTransformationService()).thenReturn((Object)this.transformationService);
        Mockito.when((Object)this.muleContext.getErrorTypeLocator()).thenReturn(Mockito.mock(ErrorTypeLocator.class, (Answer)Answers.RETURNS_DEEP_STUBS.get()));
        Mockito.when((Object)this.transformationService.transform((Message)Matchers.any(InternalMessage.class), (DataType)Matchers.any(DataType.class))).thenAnswer(invocation -> InternalMessage.builder().payload((Object)invocation.getArguments()[0].toString().getBytes()).build());
    }

    @After
    public void after() throws MuleException {
        SchedulerService schedulerService = this.muleContext.getSchedulerService();
        List createdSchedulers = schedulerService.getSchedulers();
        for (Scheduler scheduler : new ArrayList(createdSchedulers)) {
            scheduler.stop();
        }
        LifecycleUtils.stopIfNeeded((Object)schedulerService);
    }

    @Test(expected=InitialisationException.class)
    public void failWhenObjectStoreIsNull() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(null);
        this.createProcessingStrategy();
    }

    @Test
    public void alwaysFail() throws Exception {
        this.executeUntilSuccessfulFailingRoute(() -> {
            throw new RuntimeException(EXPECTED_FAILURE_MSG);
        });
        this.waitUntilRouteIsExecuted();
    }

    @Test
    public void alwaysFailUsingFailureExpression() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(() -> {
            throw new RuntimeException(EXPECTED_FAILURE_MSG);
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.times((int)1))).handleException((MessagingException)((Object)Matchers.argThat((Matcher)new ArgumentMatcher<MessagingException>(){

            public boolean matches(Object item) {
                return item instanceof MessagingException && ((MessagingException)((Object)item)).getCause() instanceof RetryPolicyExhaustedException && AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG.equals(((MessagingException)((Object)item)).getRootCause().getMessage());
            }
        })), (Event)Matchers.any(Event.class));
        ((Processor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.never())).process((Event)Matchers.any(Event.class));
    }

    @Test
    public void alwaysFailMessageUsingFailureExpression() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(() -> {
            throw new MessagingException(CoreMessages.createStaticMessage((String)EXPECTED_FAILURE_MSG), this.event, this.mockRoute);
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.times((int)1))).handleException((MessagingException)((Object)Matchers.argThat((Matcher)new ArgumentMatcher<MessagingException>(){

            public boolean matches(Object item) {
                return item instanceof MessagingException && ((MessagingException)((Object)item)).getRootCause() instanceof RetryPolicyExhaustedException && ((MessagingException)((Object)item)).getRootCause().getMessage().contains("until-successful retries exhausted. Last exception message was: expected failure");
            }
        })), (Event)Matchers.any(Event.class));
        ((Processor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.never())).process((Event)Matchers.any(Event.class));
    }

    @Test
    public void alwaysFailMessageWrapUsingFailureExpression() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(() -> {
            throw new MessagingException(this.event, (Throwable)new RuntimeException(EXPECTED_FAILURE_MSG));
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.times((int)1))).handleException((MessagingException)((Object)Matchers.argThat((Matcher)new ArgumentMatcher<MessagingException>(){

            public boolean matches(Object item) {
                return item instanceof MessagingException && ((MessagingException)((Object)item)).getRootCause() instanceof RetryPolicyExhaustedException && ((MessagingException)((Object)item)).getRootCause().getMessage().contains("until-successful retries exhausted. Last exception message was: expected failure");
            }
        })), (Event)Matchers.any(Event.class));
        ((Processor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.never())).process((Event)Matchers.any(Event.class));
    }

    @Test
    public void alwaysFailUsingFailureExpressionDLQ() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockDLQ);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(() -> {
            throw new RuntimeException(EXPECTED_FAILURE_MSG);
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class));
        ((Processor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.times((int)1))).process((Event)Matchers.argThat((Matcher)new ArgumentMatcher<Event>(){

            public boolean matches(Object argument) {
                Event argEvent = (Event)argument;
                Assert.assertThat((Object)((InternalMessage)argEvent.getMessage()).getExceptionPayload().getException().getMessage(), (Matcher)CoreMatchers.containsString((String)"until-successful retries exhausted. Last exception message was: expected failure"));
                return true;
            }
        }));
    }

    @Test
    public void alwaysFailMessageUsingFailureExpressionDLQ() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockDLQ);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(() -> {
            throw new MessagingException(CoreMessages.createStaticMessage((String)EXPECTED_FAILURE_MSG), this.event, this.mockRoute);
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class));
        ((Processor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.times((int)1))).process((Event)Matchers.argThat((Matcher)new ArgumentMatcher<Event>(){

            public boolean matches(Object argument) {
                Event argEvent = (Event)argument;
                Assert.assertThat((Object)argEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.sameInstance((Object)AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.event.getMessage().getPayload().getValue()));
                Assert.assertThat((Object)((InternalMessage)argEvent.getMessage()).getExceptionPayload().getException().getMessage(), (Matcher)CoreMatchers.containsString((String)"until-successful retries exhausted. Last exception message was: expected failure"));
                return true;
            }
        }));
    }

    @Test
    public void alwaysFailMessageWrapUsingFailureExpressionDLQ() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockDLQ);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(() -> {
            throw new MessagingException(this.event, (Throwable)new RuntimeException(EXPECTED_FAILURE_MSG));
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class));
        ((Processor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.times((int)1))).process((Event)Matchers.argThat((Matcher)new ArgumentMatcher<Event>(){

            public boolean matches(Object argument) {
                Event argEvent = (Event)argument;
                Assert.assertThat((Object)((InternalMessage)argEvent.getMessage()).getExceptionPayload().getException().getMessage(), (Matcher)CoreMatchers.containsString((String)"until-successful retries exhausted. Last exception message was: expected failure"));
                return true;
            }
        }));
    }

    @Test
    public void successfulExecution() throws Exception {
        this.executeUntilSuccessful();
        this.waitUntilRouteIsExecuted();
        ((Processor)Mockito.verify((Object)this.mockRoute, (VerificationMode)Mockito.times((int)1))).process((Event)Matchers.any(Event.class));
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class));
    }

    @Test
    public void successfulExecutionWithAckExpression() throws Exception {
        String ackExpression = "some-expression";
        String expressionEvaluationResult = "new payload";
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn((Object)ackExpression);
        TypedValue typedValue = new TypedValue((Object)expressionEvaluationResult, DataType.STRING);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager().evaluate(ackExpression, this.event)).thenReturn((Object)typedValue);
        Event result = this.executeUntilSuccessful();
        this.waitUntilRouteIsExecuted();
        ((Processor)Mockito.verify((Object)this.mockRoute, (VerificationMode)Mockito.times((int)1))).process((Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager(), (VerificationMode)Mockito.times((int)1))).evaluate((String)Matchers.eq((Object)ackExpression), (Event)Matchers.any(Event.class));
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)expressionEvaluationResult));
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockFlow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.eq((Object)this.event));
    }

    private void executeUntilSuccessfulFailingRoute(FailCallback failCallback) throws Exception {
        this.failRoute = failCallback;
        this.routeCountDownLatch = new CountDownLatch(5);
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        processingStrategy.route(this.event, (FlowConstruct)Mockito.mock(FlowConstruct.class));
    }

    private Event executeUntilSuccessful() throws Exception {
        this.routeCountDownLatch = new Latch();
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        return processingStrategy.route(this.event, (FlowConstruct)Mockito.mock(FlowConstruct.class));
    }

    private void configureMockRouteToCountDownRouteLatch() throws MuleException {
        Mockito.when((Object)this.mockRoute.process((Event)Matchers.any(Event.class))).thenAnswer(invocationOnMock -> {
            this.routeCountDownLatch.countDown();
            this.failRoute.doFail();
            return invocationOnMock.getArguments()[0];
        });
    }

    private void configureMockPoolToInvokeRunnableInNewThread() {
        ((ThreadPoolExecutor)Mockito.doAnswer(invocationOnMock -> {
            new Thread(() -> ((Runnable)invocationOnMock.getArguments()[0]).run()).start();
            return null;
        }).when((Object)this.mockPool)).execute((Runnable)Matchers.any(Runnable.class));
    }

    private void configureMockScheduledPoolToInvokeRunnableInNewThread() {
        Mockito.when(this.mockScheduledPool.schedule((Callable)Matchers.any(Callable.class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenAnswer(invocationOnMock -> {
            Assert.assertThat((Object)((Long)invocationOnMock.getArguments()[1]), (Matcher)CoreMatchers.is((Object)this.mockUntilSuccessfulConfiguration.getMillisBetweenRetries()));
            Assert.assertThat((Object)((Object)((TimeUnit)((Object)((Object)invocationOnMock.getArguments()[2])))), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MILLISECONDS)));
            new Thread(() -> {
                try {
                    ((Callable)invocationOnMock.getArguments()[0]).call();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            return null;
        });
    }

    private void waitUntilRouteIsExecuted() throws InterruptedException {
        if (!this.routeCountDownLatch.await(200000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)("route should be executed " + this.routeCountDownLatch.getCount() + " times"));
        }
    }

    private AsynchronousUntilSuccessfulProcessingStrategy createProcessingStrategy() throws Exception {
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = new AsynchronousUntilSuccessfulProcessingStrategy();
        processingStrategy.setUntilSuccessfulConfiguration(this.mockUntilSuccessfulConfiguration);
        processingStrategy.setMessagingExceptionHandler(this.mockFlow.getExceptionListener());
        processingStrategy.setMuleContext(this.muleContext);
        processingStrategy.initialise();
        processingStrategy.start();
        return processingStrategy;
    }

    private void waitUntilExceptionIsHandled() throws InterruptedException {
        if (!this.exceptionHandlingLatch.await(100000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exception should be handled");
        }
    }

    private void configureExceptionStrategyToReleaseLatchWhenExecuted() {
        Mockito.when((Object)this.mockFlow.getExceptionListener().handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class))).thenAnswer(invocationOnMock -> {
            this.exceptionHandlingLatch.release();
            return null;
        });
    }

    private void configureDLQToReleaseLatchWhenExecuted() throws MuleException {
        Mockito.when((Object)this.mockDLQ.process((Event)Matchers.any(Event.class))).thenAnswer(invocationOnMock -> {
            this.exceptionHandlingLatch.release();
            return null;
        });
    }

    private static interface FailCallback {
        public void doFail() throws Exception;
    }
}

