/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.management.stats.RouterStatistics;
import org.mule.runtime.core.routing.ChoiceRouter;
import org.mule.runtime.core.routing.filters.EqualsFilter;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class ChoiceRouterTestCase
extends AbstractReactiveProcessorTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ChoiceRouter choiceRouter;

    public ChoiceRouterTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.choiceRouter = new ChoiceRouter();
    }

    @Test
    public void testNoRoute() throws Exception {
        Event inputEvent = this.fooEvent();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, inputEvent), (Matcher)CoreMatchers.is((Object)inputEvent));
    }

    @Test
    public void testOnlyDefaultRoute() throws Exception {
        this.choiceRouter.setDefaultRoute((Processor)new TestMessageProcessor("default"));
        Assert.assertEquals((Object)"foo:default", (Object)this.process((Processor)this.choiceRouter, this.fooEvent()).getMessageAsString(muleContext));
    }

    @Test
    public void testNoMatchingNorDefaultRoute() throws Exception {
        this.choiceRouter.addRoute((Processor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        Event inputEvent = this.fooEvent();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, inputEvent), (Matcher)CoreMatchers.is((Object)inputEvent));
    }

    @Test
    public void testNoMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute((Processor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setDefaultRoute((Processor)new TestMessageProcessor("default"));
        Assert.assertEquals((Object)"foo:default", (Object)this.process((Processor)this.choiceRouter, this.fooEvent()).getMessageAsString(muleContext));
    }

    @Test
    public void testMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute((Processor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setDefaultRoute((Processor)new TestMessageProcessor("default"));
        Assert.assertEquals((Object)"zap:bar", (Object)this.process((Processor)this.choiceRouter, this.zapEvent()).getMessageAsString(muleContext));
    }

    @Test
    public void testMatchingRouteWithStatistics() throws Exception {
        this.choiceRouter.addRoute((Processor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
        Assert.assertEquals((Object)"zap:bar", (Object)this.process((Processor)this.choiceRouter, this.zapEvent()).getMessageAsString(muleContext));
    }

    @Test
    public void testAddAndDeleteRoute() throws Exception {
        TestMessageProcessor mp = new TestMessageProcessor("bar");
        this.choiceRouter.addRoute((Processor)mp, (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.removeRoute((Processor)mp);
        this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
        Event inputEvent = this.zapEvent();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, inputEvent), (Matcher)CoreMatchers.is((Object)inputEvent));
    }

    @Test
    public void testUpdateRoute() throws Exception {
        TestMessageProcessor mp = new TestMessageProcessor("bar");
        this.choiceRouter.addRoute((Processor)mp, (Filter)new EqualsFilter((Object)"paz"));
        this.choiceRouter.updateRoute((Processor)mp, (Filter)new EqualsFilter((Object)"zap"));
        Assert.assertEquals((Object)"zap:bar", (Object)this.process((Processor)this.choiceRouter, this.zapEvent()).getMessageAsString(muleContext));
    }

    protected Event fooEvent() throws MuleException {
        return ChoiceRouterTestCase.eventBuilder().message(Message.of((Object)"foo")).build();
    }

    protected Event zapEvent() throws MuleException {
        return ChoiceRouterTestCase.eventBuilder().message(Message.of((Object)"zap")).build();
    }

    @Test
    public void testRemovingUpdatingMissingRoutes() {
        this.choiceRouter.updateRoute((Processor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.removeRoute((Processor)new TestMessageProcessor("rab"));
    }
}

