/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.transformer.simple.CombineCollectionsTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CombineCollectionsTransformerTestCase
extends AbstractMuleContextTestCase {
    private CombineCollectionsTransformer merger;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.merger = new CombineCollectionsTransformer();
    }

    @Test
    public void testMuleMessageCollectionMerge() throws Exception {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(Message.builder().collectionPayload((Object[])new String[]{"1", "2", "3"}).build());
        list.add(Message.of((Object)"4"));
        list.add(Message.builder().collectionPayload((Object[])new String[]{"5", "6", "7"}).build());
        Message collection = Message.builder().collectionPayload(list, InternalMessage.class).build();
        Event event = Event.builder((Event)this.testEvent()).message(collection).build();
        Event response = this.merger.process(event);
        Assert.assertTrue((boolean)(response.getMessage().getPayload().getValue() instanceof List));
        Assert.assertEquals((long)7L, (long)((List)response.getMessage().getPayload().getValue()).size());
    }

    @Test
    public void testMuleMessageMerge() throws Exception {
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(Arrays.asList("1", "2", "3"));
        payload.add("4");
        payload.add(Arrays.asList("5", "6", "7"));
        Event event = Event.builder((Event)this.testEvent()).message((Message)InternalMessage.builder((Message)this.testEvent().getMessage()).payload(payload).build()).build();
        Event response = this.merger.process(event);
        Assert.assertTrue((boolean)(response.getMessage().getPayload().getValue() instanceof List));
        Assert.assertEquals((long)7L, (long)((List)response.getMessage().getPayload().getValue()).size());
    }
}

