/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.FirstSuccessful;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.transformer.simple.StringAppendTransformer;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class FirstSuccessfulTestCase
extends AbstractMuleContextTestCase {
    private static final String EXCEPTION_SEEN = "EXCEPTION WAS SEEN";

    public FirstSuccessfulTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testFirstSuccessful() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        FirstSuccessful fs = this.createFirstSuccessfulRouter(new TestProcessor("abc"), new TestProcessor("def"), new TestProcessor("ghi"));
        fs.initialise();
        Assert.assertEquals((Object)"No abc", (Object)this.getPayload((Processor)fs, (MuleSession)session, ""));
        Assert.assertEquals((Object)"No def", (Object)this.getPayload((Processor)fs, (MuleSession)session, "abc"));
        Assert.assertEquals((Object)"No ghi", (Object)this.getPayload((Processor)fs, (MuleSession)session, "abcdef"));
        Assert.assertEquals((Object)EXCEPTION_SEEN, (Object)this.getPayload((Processor)fs, (MuleSession)session, "abcdefghi"));
        Assert.assertEquals((Object)"No def", (Object)this.getPayload((Processor)fs, (MuleSession)session, "ABC"));
        Assert.assertEquals((Object)"No ghi", (Object)this.getPayload((Processor)fs, (MuleSession)session, "ABCDEF"));
        Assert.assertEquals((Object)EXCEPTION_SEEN, (Object)this.getPayload((Processor)fs, (MuleSession)session, "ABCDEFGHI"));
    }

    @Test
    public void testFailureExpression() throws Exception {
        Processor intSetter = event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)1).build()).build();
        FirstSuccessful fs = this.createFirstSuccessfulRouter(new Processor[]{intSetter, new StringAppendTransformer("abc")});
        fs.setFailureExpression("#[mel:payload is Integer]");
        fs.initialise();
        Assert.assertEquals((Object)"abc", (Object)fs.process(FirstSuccessfulTestCase.eventBuilder().message(Message.of((Object)"")).build()).getMessageAsString(muleContext));
    }

    @Test
    public void testRouteReturnsNullEvent() throws Exception {
        Processor nullReturningMp = event -> null;
        FirstSuccessful fs = this.createFirstSuccessfulRouter(nullReturningMp);
        fs.initialise();
        Assert.assertNull((Object)fs.process(this.testEvent()));
    }

    @Test
    public void testRouteReturnsNullMessage() throws Exception {
        Processor nullEventMp = event -> Event.builder((Event)event).message(null).build();
        FirstSuccessful fs = this.createFirstSuccessfulRouter(nullEventMp);
        fs.initialise();
        try {
            fs.process(this.testEvent());
            Assert.fail((String)"Exception expected");
        }
        catch (CouldNotRouteOutboundMessageException couldNotRouteOutboundMessageException) {
            // empty catch block
        }
    }

    private FirstSuccessful createFirstSuccessfulRouter(Processor ... processors) throws MuleException {
        FirstSuccessful fs = new FirstSuccessful();
        fs.setMuleContext(muleContext);
        List<Processor> routes = Arrays.asList(processors);
        fs.setRoutes(routes);
        return fs;
    }

    private String getPayload(Processor mp, MuleSession session, String message) throws Exception {
        Message msg = Message.of((Object)message);
        try {
            Event event = mp.process(FirstSuccessfulTestCase.eventBuilder().message(msg).session(session).build());
            Message returnedMessage = event.getMessage();
            if (event.getError().isPresent()) {
                return EXCEPTION_SEEN;
            }
            return this.getPayloadAsString(returnedMessage);
        }
        catch (Exception ex) {
            return EXCEPTION_SEEN;
        }
    }

    private static class TestProcessor
    implements Processor {
        private String rejectIfMatches;

        TestProcessor(String rejectIfMatches) {
            this.rejectIfMatches = rejectIfMatches;
        }

        public Event process(Event event) throws MuleException {
            try {
                Message msg;
                Error error = null;
                String payload = event.getMessageAsString(muleContext);
                if (payload.indexOf(this.rejectIfMatches) >= 0) {
                    throw new DefaultMuleException("Saw " + this.rejectIfMatches);
                }
                if (payload.toLowerCase().indexOf(this.rejectIfMatches) >= 0) {
                    Exception exception = new Exception();
                    error = MuleTestUtils.createErrorMock((Exception)exception);
                    msg = InternalMessage.builder().nullPayload().exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)exception)).build();
                } else {
                    msg = Message.of((Object)("No " + this.rejectIfMatches));
                }
                Event muleEvent = FirstSuccessfulTestCase.eventBuilder().message(msg).error(error).build();
                return muleEvent;
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }
}

