/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.Foreach;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class ForeachTestCase
extends AbstractReactiveProcessorTestCase {
    protected Foreach simpleForeach;
    protected Foreach nestedForeach;
    protected ArrayList<Event> processedEvents;
    private static String ERR_NUMBER_MESSAGES = "Not a correct number of messages processed";
    private static String ERR_PAYLOAD_TYPE = "Type error on processed payloads";
    private static String ERR_OUTPUT = "Messages processed incorrectly";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public ForeachTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Before
    public void initialise() throws MuleException {
        this.processedEvents = new ArrayList();
        this.simpleForeach = this.createForeach(this.getSimpleMessageProcessors());
        this.nestedForeach = this.createForeach(this.getNestedMessageProcessors());
    }

    private List<Processor> getSimpleMessageProcessors() {
        ArrayList<Processor> lmp = new ArrayList<Processor>();
        lmp.add(event -> {
            String payload = event.getMessage().getPayload().getValue().toString();
            event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)(payload + ":foo")).build()).build();
            return event;
        });
        lmp.add((Processor)new TestMessageProcessor("zas"));
        lmp.add(event -> {
            this.processedEvents.add(event);
            return event;
        });
        return lmp;
    }

    private List<Processor> getNestedMessageProcessors() throws MuleException {
        ArrayList<Processor> lmp = new ArrayList<Processor>();
        Foreach internalForeach = new Foreach();
        internalForeach.setMessageProcessors(this.getSimpleMessageProcessors());
        lmp.add((Processor)internalForeach);
        return lmp;
    }

    private Foreach createForeach(List<Processor> mps) throws MuleException {
        Foreach foreachMp = new Foreach();
        foreachMp.setMessageProcessors(mps);
        foreachMp.setMuleContext(muleContext);
        foreachMp.initialise();
        return foreachMp;
    }

    @Test
    public void arrayListPayload() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("bar");
        arrayList.add("zip");
        this.process((Processor)this.simpleForeach, ForeachTestCase.eventBuilder().message(Message.of(arrayList)).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void arrayPayload() throws Exception {
        String[] array = new String[]{"bar", "zip"};
        this.process((Processor)this.simpleForeach, ForeachTestCase.eventBuilder().message(Message.of((Object)array)).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void muleMessageCollectionPayload() throws Exception {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(Message.of((Object)"bar"));
        list.add(Message.of((Object)"zip"));
        this.process((Processor)this.simpleForeach, ForeachTestCase.eventBuilder().message(Message.of(list)).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void iterablePayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        Event testEvent = ForeachTestCase.eventBuilder().message(Message.of((Object)iterable)).build();
        this.process((Processor)this.simpleForeach, testEvent);
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void iteratorPayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        this.process((Processor)this.simpleForeach, ForeachTestCase.eventBuilder().message(Message.of(iterable.iterator())).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void nestedArrayListPayload() throws Exception {
        ArrayList payload = new ArrayList();
        ArrayList<String> elem1 = new ArrayList<String>();
        ArrayList<String> elem2 = new ArrayList<String>();
        ArrayList<String> elem3 = new ArrayList<String>();
        elem1.add("a1");
        elem1.add("a2");
        elem1.add("a3");
        elem2.add("b1");
        elem2.add("b2");
        elem3.add("c1");
        payload.add(elem1);
        payload.add(elem2);
        payload.add(elem3);
        this.process((Processor)this.nestedForeach, ForeachTestCase.eventBuilder().message(Message.of(payload)).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedArrayPayload() throws Exception {
        String[][] payload = new String[3][2];
        payload[0][0] = "a1";
        payload[0][1] = "a2";
        payload[1][0] = "a3";
        payload[1][1] = "b1";
        payload[2][0] = "b2";
        payload[2][1] = "c1";
        this.process((Processor)this.nestedForeach, ForeachTestCase.eventBuilder().message(Message.of((Object)payload)).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedMuleMessageCollectionPayload() throws Exception {
        ArrayList<Message> parentList = new ArrayList<Message>();
        ArrayList<Message> list1 = new ArrayList<Message>();
        ArrayList<Message> list2 = new ArrayList<Message>();
        list1.add(Message.of((Object)"a1"));
        list1.add(Message.of((Object)"a2"));
        list1.add(Message.of((Object)"a3"));
        list2.add(Message.of((Object)"b1"));
        list2.add(Message.of((Object)"b2"));
        list2.add(Message.of((Object)"c1"));
        parentList.add(Message.of(list1));
        parentList.add(Message.of(list2));
        Message parentCollection = Message.of(parentList);
        this.process((Processor)this.nestedForeach, ForeachTestCase.eventBuilder().message(parentCollection).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedIterablePayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.process((Processor)this.nestedForeach, ForeachTestCase.eventBuilder().message(Message.of((Object)iterable)).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedIteratorPayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.process((Processor)this.nestedForeach, ForeachTestCase.eventBuilder().message(Message.of((Object)iterable)).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void failingNestedProcessor() throws Exception {
        BufferOverflowException throwable = new BufferOverflowException();
        Foreach foreach = new Foreach();
        foreach.setMuleContext(muleContext);
        Processor failingProcessor = event -> {
            throw throwable;
        };
        foreach.setMessageProcessors(Collections.singletonList(failingProcessor));
        foreach.initialise();
        this.expectedException.expect(CoreMatchers.is(MessagingException.class));
        this.expectedException.expect((Matcher)new FailingProcessorMatcher(failingProcessor));
        this.expectedException.expectCause(CoreMatchers.is((Object)throwable));
        this.process((Processor)foreach, ForeachTestCase.eventBuilder().message(Message.of(new DummyNestedIterableClass().iterator())).build(), false);
    }

    @Test
    public void failingExpression() throws Exception {
        Foreach foreach = new Foreach();
        foreach.setMuleContext(muleContext);
        foreach.setCollectionExpression("!@INVALID");
        foreach.setMessageProcessors(this.getSimpleMessageProcessors());
        foreach.initialise();
        this.expectedException.expect(CoreMatchers.instanceOf(MessagingException.class));
        this.expectedException.expect((Matcher)new FailingProcessorMatcher((Processor)foreach));
        this.expectedException.expectCause(CoreMatchers.instanceOf(ExpressionRuntimeException.class));
        this.process((Processor)foreach, ForeachTestCase.eventBuilder().message(Message.of(new DummyNestedIterableClass().iterator())).build(), false);
    }

    private void assertSimpleProcessedMessages() {
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)2L, (long)this.processedEvents.size());
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(0).getMessage().getPayload().getValue() instanceof String));
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(1).getMessage().getPayload().getValue() instanceof String));
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"bar:foo:zas", (Object)this.processedEvents.get(0).getMessage().getPayload().getValue());
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"zip:foo:zas", (Object)this.processedEvents.get(1).getMessage().getPayload().getValue());
    }

    private void assertNestedProcessedMessages() {
        int i;
        String[] expectedOutputs = new String[]{"a1:foo:zas", "a2:foo:zas", "a3:foo:zas", "b1:foo:zas", "b2:foo:zas", "c1:foo:zas"};
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)6L, (long)this.processedEvents.size());
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(i).getMessage().getPayload().getValue() instanceof String));
        }
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertEquals((String)ERR_OUTPUT, (Object)expectedOutputs[i], (Object)this.processedEvents.get(i).getMessage().getPayload().getValue());
        }
    }

    private static class FailingProcessorMatcher
    extends BaseMatcher<MessagingException> {
        private Processor expectedFailingProcessor;

        FailingProcessorMatcher(Processor processor) {
            this.expectedFailingProcessor = processor;
        }

        public boolean matches(Object o) {
            return o instanceof MessagingException && ((MessagingException)((Object)o)).getFailingMessageProcessor() == this.expectedFailingProcessor;
        }

        public void describeTo(Description description) {
            description.appendText("Exception is not a MessagingException or failing processor does not match.");
        }
    }

    private class DummyNestedIterableClass
    implements Iterable<DummySimpleIterableClass> {
        private List<DummySimpleIterableClass> iterables = new ArrayList<DummySimpleIterableClass>();

        public DummyNestedIterableClass() {
            DummySimpleIterableClass dsi1 = new DummySimpleIterableClass();
            dsi1.strings = new ArrayList<String>();
            dsi1.strings.add("a1");
            dsi1.strings.add("a2");
            DummySimpleIterableClass dsi2 = new DummySimpleIterableClass();
            dsi2.strings = new ArrayList<String>();
            dsi2.strings.add("a3");
            dsi2.strings.add("b1");
            dsi2.strings.add("b2");
            dsi2.strings.add("c1");
            this.iterables.add(dsi1);
            this.iterables.add(dsi2);
        }

        @Override
        public Iterator<DummySimpleIterableClass> iterator() {
            return this.iterables.iterator();
        }
    }

    public class DummySimpleIterableClass
    implements Iterable<String> {
        public List<String> strings = new ArrayList<String>();

        public DummySimpleIterableClass() {
            this.strings.add("bar");
            this.strings.add("zip");
        }

        @Override
        public Iterator<String> iterator() {
            return this.strings.iterator();
        }
    }
}

