/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.routing.ValidationException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.IdempotentMessageValidator;
import org.mule.tck.core.util.store.InMemoryObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class IdempotentMessageValidatorTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void idempotentReceiver() throws Exception {
        IdempotentMessageValidator idempotent = new IdempotentMessageValidator();
        idempotent.setMuleContext(muleContext);
        idempotent.setStorePrefix("foo");
        idempotent.setObjectStore((ObjectStore)new InMemoryObjectStore());
        EventContext contextA = (EventContext)Mockito.mock(EventContext.class);
        Mockito.when((Object)contextA.getId()).thenReturn((Object)"1");
        InternalMessage okMessage = InternalMessage.builder().payload((Object)"OK").build();
        Event event = Event.builder((EventContext)contextA).message((Message)okMessage).build();
        Event processedEvent = idempotent.process(event);
        Assert.assertThat((Object)processedEvent, (Matcher)Matchers.sameInstance((Object)event));
        EventContext contextB = (EventContext)Mockito.mock(EventContext.class);
        Mockito.when((Object)contextB.getId()).thenReturn((Object)"1");
        event = Event.builder((EventContext)contextB).message((Message)okMessage).build();
        this.expected.expect(ValidationException.class);
        processedEvent = idempotent.process(event);
    }
}

