/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.routing.ValidationException;
import org.mule.runtime.core.routing.IdempotentSecureHashMessageValidator;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.core.util.store.InMemoryObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class IdempotentSecureHashMessageValidatorTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private IdempotentSecureHashMessageValidator secureHash;
    private EventContext context;

    public IdempotentSecureHashMessageValidatorTestCase() {
        this.setStartContext(true);
    }

    @Before
    public void before() throws MuleException {
        Flow flow = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        this.secureHash = new IdempotentSecureHashMessageValidator();
        this.secureHash.setFlowConstruct((FlowConstruct)flow);
        this.secureHash.setStorePrefix("foo");
        this.secureHash.setObjectStore((ObjectStore)new InMemoryObjectStore());
        this.secureHash.setMuleContext(muleContext);
        this.context = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
    }

    @Test
    public void secureHashFiltered() throws Exception {
        Message okMessage = Message.of((Object)"OK");
        Event event = Event.builder((EventContext)this.context).message(okMessage).build();
        Event processedEvent = this.secureHash.process(event);
        Assert.assertNotNull((Object)processedEvent);
        okMessage = Message.of((Object)"OK");
        event = Event.builder((EventContext)this.context).message(okMessage).build();
        this.expected.expect(ValidationException.class);
        processedEvent = this.secureHash.process(event);
    }

    @Test
    public void secureHashNotFiltered() throws Exception {
        Message okMessage = Message.of((Object)"OK");
        Event event = Event.builder((EventContext)this.context).message(okMessage).build();
        Event processedEvent = this.secureHash.process(event);
        Assert.assertNotNull((Object)processedEvent);
        okMessage = Message.of((Object)"Not OK");
        event = Event.builder((EventContext)this.context).message(okMessage).build();
        processedEvent = this.secureHash.process(event);
        Assert.assertNotNull((Object)processedEvent);
    }
}

