/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.message.GroupCorrelation;
import org.mule.runtime.core.routing.MessageChunkAggregator;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class MessageChunkAggregatorTestCase
extends AbstractMuleContextTestCase {
    public MessageChunkAggregatorTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageProcessor() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Flow flow = MessageChunkAggregatorTestCase.getTestFlowWithComponent((String)"test", Apple.class);
        Assert.assertNotNull((Object)flow);
        MessageChunkAggregator router = new MessageChunkAggregator();
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        EventContext context = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Event event1 = Event.builder((EventContext)context).message(message1).groupCorrelation(new GroupCorrelation(Integer.valueOf(3), null)).flow((FlowConstruct)flow).session((MuleSession)session).build();
        Event event2 = Event.builder((EventContext)context).message(message2).flow((FlowConstruct)flow).session((MuleSession)session).build();
        Event event3 = Event.builder((EventContext)context).message(message3).flow((FlowConstruct)flow).session((MuleSession)session).build();
        Assert.assertNull((Object)router.process(event1));
        Assert.assertNull((Object)router.process(event2));
        Event resultEvent = router.process(event3);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        String payload = this.getPayloadAsString(resultMessage);
        Assert.assertTrue((boolean)payload.contains("test event A"));
        Assert.assertTrue((boolean)payload.contains("test event B"));
        Assert.assertTrue((boolean)payload.contains("test event C"));
        Assert.assertTrue((boolean)payload.matches("test event [A,B,C]test event [A,B,C]test event [A,B,C]"));
    }
}

