/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.routing.MessageFilter;
import org.mule.runtime.core.routing.filters.EqualsFilter;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;

public class MessageFilterTestCase
extends AbstractReactiveProcessorTestCase {
    public MessageFilterTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Test
    public void testFilterPass() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter((Object)"test"), false, null);
        SensingNullMessageProcessor listener = this.getSensingNullMessageProcessor();
        mp.setListener((Processor)listener);
        mp.setMuleContext(muleContext);
        Event resultEvent = this.process((Processor)mp, this.testEvent());
        Assert.assertNotNull((Object)listener.event);
        Assert.assertEquals((Object)this.testEvent().getMessage(), (Object)resultEvent.getMessage());
    }

    @Test
    public void testFilterFail() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter(null), false, null);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        mp.setMuleContext(muleContext);
        mp.setListener((Processor)out);
        Event resultEvent = this.process((Processor)mp, this.testEvent());
        Assert.assertNull((Object)out.event);
        Assert.assertNull((Object)resultEvent);
    }

    @Test
    public void testFilterPassUnacceptedMP() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter((Object)"test"), false, null);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        SensingNullMessageProcessor unaccepted = this.getSensingNullMessageProcessor();
        mp.setListener((Processor)out);
        mp.setMuleContext(muleContext);
        mp.setUnacceptedMessageProcessor((Processor)unaccepted);
        Event resultEvent = this.process((Processor)mp, this.testEvent());
        Assert.assertNotNull((Object)out.event);
        Assert.assertEquals((Object)this.testEvent().getMessage(), (Object)resultEvent.getMessage());
        Assert.assertNull((Object)unaccepted.event);
    }

    @Test
    public void testFilterFailUnacceptedMP() throws Exception {
        SensingNullMessageProcessor unaccepted = this.getSensingNullMessageProcessor();
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter(null), false, (Processor)unaccepted);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        mp.setMuleContext(muleContext);
        mp.setListener((Processor)out);
        Event inEvent = MessageFilterTestCase.eventBuilder().message(Message.of((Object)"Test Message")).build();
        Event resultEvent = this.process((Processor)mp, inEvent);
        Assert.assertNull((Object)out.event);
        Assert.assertSame((Object)inEvent, (Object)resultEvent);
        Assert.assertNotNull((Object)unaccepted.event);
    }
}

