/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.routing.EventGroup;
import org.mule.runtime.core.routing.Resequencer;
import org.mule.runtime.core.routing.correlation.CorrelationSequenceComparator;
import org.mule.runtime.core.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.routing.correlation.ResequenceMessagesCorrelatorCallback;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class ResequencerTestCase
extends AbstractMuleContextTestCase {
    public ResequencerTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageResequencer() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Flow flow = ResequencerTestCase.getTestFlowWithComponent((String)"test", Apple.class);
        Assert.assertNotNull((Object)flow);
        TestEventResequencer router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        EventContext context = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        Event event1 = Event.builder((EventContext)context).message(message1).flow((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)).session((MuleSession)session).build();
        Event event2 = Event.builder((EventContext)context).message(message2).flow((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)).session((MuleSession)session).build();
        Event event3 = Event.builder((EventContext)context).message(message3).flow((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)).session((MuleSession)session).build();
        Assert.assertNull((Object)router.process(event2));
        Assert.assertNull((Object)router.process(event3));
        Event resultEvent = router.process(event1);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((this.getPayloadAsString(resultMessage).equals("test event A") || this.getPayloadAsString(resultMessage).equals("test event B") || this.getPayloadAsString(resultMessage).equals("test event C") ? 1 : 0) != 0);
    }

    @Test
    public void testMessageResequencerWithComparator() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Flow flow = ResequencerTestCase.getTestFlowWithComponent((String)"test", Apple.class);
        Assert.assertNotNull((Object)flow);
        TestEventResequencer router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        EventContext context = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        Event event1 = Event.builder((EventContext)context).message(message1).flow((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)).session((MuleSession)session).build();
        Event event2 = Event.builder((EventContext)context).message(message2).flow((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)).session((MuleSession)session).build();
        Event event3 = Event.builder((EventContext)context).message(message3).flow((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)).session((MuleSession)session).build();
        router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setEventComparator(new EventPayloadComparator());
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        Assert.assertNull((Object)router.process(event2));
        Assert.assertNull((Object)router.process(event3));
        Event resultEvent = router.process(event1);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertEquals((Object)"test event C", (Object)this.getPayloadAsString(resultMessage));
    }

    public static class EventPayloadComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                return ((Event)o1).getMessageAsString(muleContext).compareTo(((Event)o2).getMessageAsString(muleContext));
            }
            catch (MuleException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public static class TestEventResequencer
    extends Resequencer {
        private int eventCount = 0;
        private int eventthreshold = 1;

        public TestEventResequencer(int eventthreshold) {
            this.eventthreshold = eventthreshold;
            this.setEventComparator((Comparator)new CorrelationSequenceComparator());
        }

        protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
            return new ResequenceMessagesCorrelatorCallback(this.getEventComparator(), muleContext, this.storePrefix){

                public boolean shouldAggregateEvents(EventGroup events) {
                    eventCount++;
                    if (eventCount == eventthreshold) {
                        eventCount = 0;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

