/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.message.GroupCorrelation;
import org.mule.runtime.core.routing.SimpleCollectionAggregator;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class SimpleCollectionAggregatorTestCase
extends AbstractMuleContextTestCase {
    public SimpleCollectionAggregatorTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testAggregateMultipleEvents() throws Exception {
        Flow flow = SimpleCollectionAggregatorTestCase.getTestFlowWithComponent((String)"test", Apple.class);
        Assert.assertNotNull((Object)flow);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        SensingNullMessageProcessor sensingMessageProcessor = this.getSensingNullMessageProcessor();
        router.setListener((Processor)sensingMessageProcessor);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        EventContext executionContext = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        Event event1 = Event.builder((EventContext)executionContext).message(message1).groupCorrelation(new GroupCorrelation(Integer.valueOf(3), null)).flow((FlowConstruct)flow).build();
        Event event2 = Event.builder((EventContext)executionContext).message(message2).flow((FlowConstruct)flow).build();
        Event event3 = Event.builder((EventContext)executionContext).message(message3).flow((FlowConstruct)flow).build();
        Assert.assertNull((Object)router.process(event1));
        Assert.assertNull((Object)router.process(event2));
        Event resultEvent = router.process(event3);
        Assert.assertNotNull((Object)sensingMessageProcessor.event);
        Assert.assertThat((Object)resultEvent, (Matcher)CoreMatchers.equalTo((Object)sensingMessageProcessor.event));
        Message nextMessage = sensingMessageProcessor.event.getMessage();
        Assert.assertNotNull((Object)nextMessage);
        Assert.assertTrue((boolean)(nextMessage.getPayload().getValue() instanceof List));
        List list = (List)nextMessage.getPayload().getValue();
        Assert.assertEquals((long)3L, (long)list.size());
        Object[] results = new String[3];
        list.stream().map(msg -> msg.getPayload().getValue()).collect(Collectors.toList()).toArray(results);
        Arrays.sort(results);
        Assert.assertEquals((Object)"test event A", (Object)results[0]);
        Assert.assertEquals((Object)"test event B", (Object)results[1]);
        Assert.assertEquals((Object)"test event C", (Object)results[2]);
    }

    @Test
    public void testAggregateSingleEvent() throws Exception {
        Flow flow = SimpleCollectionAggregatorTestCase.getTestFlowWithComponent((String)"test", Apple.class);
        Assert.assertNotNull((Object)flow);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        SensingNullMessageProcessor sensingMessageProcessor = this.getSensingNullMessageProcessor();
        router.setListener((Processor)sensingMessageProcessor);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        EventContext executionContext = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Event event1 = Event.builder((EventContext)executionContext).message(message1).groupCorrelation(new GroupCorrelation(Integer.valueOf(1), null)).flow((FlowConstruct)flow).build();
        Event resultEvent = router.process(event1);
        Assert.assertNotNull((Object)sensingMessageProcessor.event);
        Assert.assertThat((Object)resultEvent, (Matcher)CoreMatchers.equalTo((Object)sensingMessageProcessor.event));
        Message nextMessage = sensingMessageProcessor.event.getMessage();
        Assert.assertNotNull((Object)nextMessage);
        Assert.assertTrue((boolean)(nextMessage.getPayload().getValue() instanceof List));
        List payload = (List)nextMessage.getPayload().getValue();
        Assert.assertEquals((long)1L, (long)payload.size());
        Assert.assertEquals((Object)"test event A", (Object)((InternalMessage)payload.get(0)).getPayload().getValue());
    }

    @Test
    public void testAggregateMessageCollections() throws Exception {
        Flow flow = SimpleCollectionAggregatorTestCase.getTestFlowWithComponent((String)"test", Apple.class);
        Assert.assertNotNull((Object)flow);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)flow);
        router.initialise();
        EventContext executionContext = DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        Message message4 = Message.of((Object)"test event D");
        ArrayList<Message> list = new ArrayList<Message>();
        ArrayList<Message> list2 = new ArrayList<Message>();
        list.add(message1);
        list.add(message2);
        list2.add(message3);
        list2.add(message4);
        Message messageCollection1 = Message.of(list);
        Message messageCollection2 = Message.of(list2);
        Event event1 = Event.builder((EventContext)executionContext).message(messageCollection1).groupCorrelation(new GroupCorrelation(Integer.valueOf(2), null)).flow((FlowConstruct)flow).build();
        Event event2 = Event.builder((EventContext)executionContext).message(messageCollection2).groupCorrelation(new GroupCorrelation(Integer.valueOf(2), null)).flow((FlowConstruct)flow).build();
        Assert.assertNull((Object)router.process(event1));
        Event resultEvent = router.process(event2);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        List payload = (List)resultMessage.getPayload().getValue();
        Assert.assertEquals((long)2L, (long)payload.size());
        Assert.assertEquals((Object)"test event A", (Object)((InternalMessage)((List)((InternalMessage)payload.get(0)).getPayload().getValue()).get(0)).getPayload().getValue());
        Assert.assertEquals((Object)"test event B", (Object)((InternalMessage)((List)((InternalMessage)payload.get(0)).getPayload().getValue()).get(1)).getPayload().getValue());
        Assert.assertEquals((Object)"test event C", (Object)((InternalMessage)((List)((InternalMessage)payload.get(1)).getPayload().getValue()).get(0)).getPayload().getValue());
        Assert.assertEquals((Object)"test event D", (Object)((InternalMessage)((List)((InternalMessage)payload.get(1)).getPayload().getValue()).get(1)).getPayload().getValue());
    }
}

