/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.Splitter;
import org.mule.runtime.core.routing.outbound.IteratorMessageSequence;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SplitterTestCase
extends AbstractMuleContextTestCase {
    private static final List<String> TEST_LIST_MULTIPLE = Arrays.asList("abc", "def", "ghi");
    private static final List<String> TEST_LIST_SINGLE = Arrays.asList("abc");

    public SplitterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testRouterCollection() throws Exception {
        this.assertRouted(TEST_LIST_MULTIPLE, 3, true);
    }

    @Test
    public void testRouterSingletonCollection() throws Exception {
        this.assertRouted(TEST_LIST_SINGLE, 1, true);
    }

    @Test
    public void testRouterArray() throws Exception {
        this.assertRouted(new String[]{"abc", "def", "ghi"}, 3, true);
    }

    @Test
    public void testRouterIterable() throws Exception {
        Iterable mock = (Iterable)Mockito.mock(Iterable.class);
        Mockito.when(mock.iterator()).thenReturn(TEST_LIST_MULTIPLE.iterator());
        this.assertRouted(mock, 3, false);
        ((Iterable)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).iterator();
    }

    @Test
    public void testRouterIterableSingleItem() throws Exception {
        Iterable mock = (Iterable)Mockito.mock(Iterable.class);
        Mockito.when(mock.iterator()).thenReturn(TEST_LIST_SINGLE.iterator());
        this.assertRouted(mock, 1, false);
        ((Iterable)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).iterator();
    }

    @Test
    public void testRouterIterator() throws Exception {
        this.assertRouted(TEST_LIST_MULTIPLE.iterator(), 3, false);
    }

    @Test
    public void testRouterIteratorSingleItem() throws Exception {
        this.assertRouted(TEST_LIST_SINGLE.iterator(), 1, false);
    }

    @Test
    public void testRouterMesseageSequence() throws Exception {
        this.assertRouted(new IteratorMessageSequence(TEST_LIST_MULTIPLE.iterator()), 3, false);
    }

    @Test
    public void testEmptySequence() throws Exception {
        Set payload = Collections.emptySet();
        DefaultMuleSession session = new DefaultMuleSession();
        Message toSplit = Message.of(payload);
        Splitter splitter = new Splitter();
        splitter.setMuleContext(muleContext);
        splitter.initialise();
        Event event = SplitterTestCase.eventBuilder().message(toSplit).session((MuleSession)session).build();
        Assert.assertSame((Object)event, (Object)splitter.process(event));
    }

    @Test
    public void testSingleMesseageSequence() throws Exception {
        this.assertRouted(new IteratorMessageSequence(TEST_LIST_SINGLE.iterator()), 1, false);
    }

    private void assertRouted(Object payload, int count, boolean counted) throws Exception, MuleException {
        DefaultMuleSession session = new DefaultMuleSession();
        HashMap<String, Serializable> inboundProps = new HashMap<String, Serializable>();
        inboundProps.put("inbound1", (Serializable)((Object)"1"));
        inboundProps.put("inbound2", Integer.valueOf(2));
        inboundProps.put("inbound3", (Serializable)session);
        HashMap<String, Serializable> outboundProps = new HashMap<String, Serializable>();
        outboundProps.put("outbound1", (Serializable)((Object)"3"));
        outboundProps.put("outbound2", Integer.valueOf(4));
        outboundProps.put("outbound3", (Serializable)session);
        HashMap<String, Object> invocationProps = new HashMap<String, Object>();
        invocationProps.put("invoke1", "5");
        invocationProps.put("invoke2", 6);
        invocationProps.put("invoke3", session);
        HashSet<Integer> expectedSequences = new HashSet<Integer>();
        for (int i = 1; i <= count; ++i) {
            expectedSequences.add(i);
        }
        InternalMessage toSplit = InternalMessage.builder().payload(payload).inboundProperties(inboundProps).outboundProperties(outboundProps).build();
        Splitter splitter = new Splitter();
        Grabber grabber = new Grabber();
        splitter.setMuleContext(muleContext);
        splitter.setListener((Processor)grabber);
        splitter.initialise();
        Event.Builder eventBuilder = SplitterTestCase.eventBuilder().message((Message)toSplit).session((MuleSession)session);
        for (Map.Entry entry : invocationProps.entrySet()) {
            eventBuilder.addVariable((String)entry.getKey(), entry.getValue());
        }
        Event event = eventBuilder.build();
        splitter.process(event);
        List<Event> splits = grabber.getEvents();
        Assert.assertEquals((long)count, (long)splits.size());
        HashSet<Object> actualSequences = new HashSet<Object>();
        this.assertSplitParts(count, counted, inboundProps, outboundProps, invocationProps, splits, actualSequences);
        Assert.assertEquals(expectedSequences, actualSequences);
    }

    private void assertSplitParts(int count, boolean counted, Map<String, Serializable> inboundProps, Map<String, Serializable> outboundProps, Map<String, Object> invocationProps, List<Event> splits, Set<Object> actualSequences) {
        for (Event event : splits) {
            Message msg = event.getMessage();
            Assert.assertTrue((boolean)(msg.getPayload().getValue() instanceof String));
            if (counted) {
                Assert.assertThat(event.getGroupCorrelation().getGroupSize().get(), (Matcher)CoreMatchers.is((Object)count));
            } else {
                Assert.assertThat((Object)event.getGroupCorrelation().getGroupSize().isPresent(), (Matcher)CoreMatchers.is((Object)false));
            }
            actualSequences.add(event.getGroupCorrelation().getSequence().get());
            String str = (String)msg.getPayload().getValue();
            Assert.assertTrue((boolean)TEST_LIST_MULTIPLE.contains(str));
            for (String key : inboundProps.keySet()) {
                Assert.assertEquals((Object)((InternalMessage)msg).getInboundProperty(key), (Object)inboundProps.get(key));
            }
            for (String key : outboundProps.keySet()) {
                Assert.assertEquals((Object)((InternalMessage)msg).getOutboundProperty(key), (Object)outboundProps.get(key));
            }
            for (String key : invocationProps.keySet()) {
                Assert.assertEquals((Object)event.getVariable(key).getValue(), (Object)invocationProps.get(key));
            }
        }
    }

    private static class Grabber
    implements Processor {
        private List<Event> events = new ArrayList<Event>();

        private Grabber() {
        }

        public Event process(Event event) throws MuleException {
            this.events.add(event);
            return null;
        }

        public List<Event> getEvents() {
            return this.events;
        }
    }
}

