/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.SynchronousUntilSuccessfulProcessingStrategy;
import org.mule.runtime.core.routing.UntilSuccessfulConfiguration;
import org.mule.runtime.core.routing.filters.ExpressionFilter;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SynchronousUntilSuccessfulProcessingStrategyTestCase
extends AbstractMuleContextTestCase {
    private static final int DEFAULT_RETRIES = 4;
    private static final String PROCESSED_DATA = "Processed Data";
    private UntilSuccessfulConfiguration mockUntilSuccessfulConfiguration = (UntilSuccessfulConfiguration)Mockito.mock(UntilSuccessfulConfiguration.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Processor mockRoute = (Processor)Mockito.mock(Processor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ExpressionFilter mockAlwaysTrueFailureExpressionFilter = (ExpressionFilter)Mockito.mock(ExpressionFilter.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ListableObjectStore<Event> mockObjectStore = (ListableObjectStore)Mockito.mock(ListableObjectStore.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.mockAlwaysTrueFailureExpressionFilter.accept((Event)Matchers.any(Event.class), (Event.Builder)Matchers.any(Event.Builder.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getRoute()).thenReturn((Object)this.mockRoute);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMaxRetries()).thenReturn((Object)4);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Event.setCurrentEvent(null);
    }

    @Test(expected=InitialisationException.class)
    public void failWhenObjectStoreIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.mockObjectStore);
        this.createProcessingStrategy();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenDlqIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.mockObjectStore);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockRoute);
        this.createProcessingStrategy();
    }

    @Test
    public void alwaysFail() throws Exception {
        Mockito.when((Object)this.mockRoute.process((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{new RuntimeException("expected failure")});
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        try {
            processingStrategy.route(this.testEvent(), (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
            Assert.fail((String)"processing should throw exception");
        }
        catch (RoutingException e) {
            ((Processor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process((Event)Matchers.any(Event.class));
        }
    }

    @Test
    public void alwaysFailUsingFailureExpression() throws Exception {
        Event testEvent = this.testEvent();
        Mockito.when((Object)this.mockRoute.process((Event)Matchers.any(Event.class))).thenReturn((Object)testEvent);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        try {
            processingStrategy.route(this.testEvent(), (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
            Assert.fail((String)"processing should throw exception");
        }
        catch (RoutingException e) {
            ((Processor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process((Event)Matchers.any(Event.class));
            ((ExpressionFilter)Mockito.verify((Object)this.mockAlwaysTrueFailureExpressionFilter, (VerificationMode)VerificationModeFactory.times((int)5))).accept((Event)Matchers.any(Event.class), (Event.Builder)Matchers.any(Event.Builder.class));
        }
    }

    @Test
    public void successfulExecution() throws Exception {
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process((Event)Matchers.any(Event.class))).thenAnswer(invocation -> (Event)invocation.getArguments()[0]);
        Event response = processingStrategy.route(this.testEvent(), (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)IsEqual.equalTo((Object)this.testEvent().getMessage().getPayload().getValue()));
        ((Processor)Mockito.verify((Object)this.mockRoute)).process((Event)Matchers.any(Event.class));
        Assert.assertThat((Object)Event.getCurrentEvent(), (Matcher)IsSame.sameInstance((Object)response));
    }

    @Test
    public void retryOnOriginalEvent() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process((Event)Matchers.any(Event.class))).then(invocation -> {
            Event argEvent = (Event)invocation.getArguments()[0];
            Assert.assertThat((Object)argEvent.getMessageAsString(muleContext), (Matcher)Is.is((Object)"test"));
            return Event.builder((Event)argEvent).message((Message)InternalMessage.builder((Message)argEvent.getMessage()).payload((Object)PROCESSED_DATA).build()).build();
        });
        try {
            processingStrategy.route(this.testEvent(), (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
            Assert.fail((String)"processing should throw exception");
        }
        catch (RoutingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)IsInstanceOf.instanceOf(RoutingException.class));
            ((Processor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process((Event)Matchers.any(Event.class));
            ((ExpressionFilter)Mockito.verify((Object)this.mockAlwaysTrueFailureExpressionFilter, (VerificationMode)VerificationModeFactory.times((int)5))).accept((Event)Matchers.any(Event.class), (Event.Builder)Matchers.any(Event.Builder.class));
        }
    }

    @Test
    public void successfulExecutionWithAckExpression() throws Exception {
        String ackExpression = "some-expression";
        String expressionEvaluationResult = "new payload";
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn((Object)ackExpression);
        TypedValue typedValue = new TypedValue((Object)expressionEvaluationResult, DataType.STRING);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager().evaluate((String)Matchers.eq((Object)ackExpression), (Event)Matchers.any(Event.class))).thenReturn((Object)typedValue);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process((Event)Matchers.any(Event.class))).thenAnswer(invocation -> (Event)invocation.getArguments()[0]);
        Event response = processingStrategy.route(this.testEvent(), (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)IsEqual.equalTo((Object)expressionEvaluationResult));
        ((Processor)Mockito.verify((Object)this.mockRoute)).process((Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager())).evaluate((String)Matchers.eq((Object)ackExpression), (Event)Matchers.any(Event.class));
    }

    @Test
    public void successfulWithNullResponseFromRoute() throws Exception {
        Mockito.when((Object)this.mockRoute.process((Event)Matchers.any(Event.class))).thenReturn(null);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Assert.assertThat((Object)processingStrategy.route(this.testEvent(), (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext)), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    private SynchronousUntilSuccessfulProcessingStrategy createProcessingStrategy() throws InitialisationException {
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = new SynchronousUntilSuccessfulProcessingStrategy();
        processingStrategy.setUntilSuccessfulConfiguration(this.mockUntilSuccessfulConfiguration);
        processingStrategy.initialise();
        return processingStrategy;
    }
}

