/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.runtime.core.routing.UntilSuccessful;
import org.mule.runtime.core.util.store.SimpleMemoryObjectStore;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;

public class UntilSuccessfulTestCase
extends AbstractMuleContextTestCase {
    private UntilSuccessful untilSuccessful;
    private ListableObjectStore<Event> objectStore;
    private ConfigurableMessageProcessor targetMessageProcessor;
    private Prober pollingProber = new PollingProber(10000L, 500L);
    private Flow mockFlow;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.untilSuccessful = this.buildUntiSuccessful(1000L);
        this.mockFlow = (Flow)Mockito.mock(DefaultFlowBuilder.DefaultFlow.class);
    }

    private UntilSuccessful buildUntiSuccessful(Long millisBetweenRetries) throws Exception {
        UntilSuccessful untilSuccessful = new UntilSuccessful();
        untilSuccessful.setMuleContext(muleContext);
        untilSuccessful.setMessagingExceptionHandler(muleContext.getDefaultErrorHandler());
        untilSuccessful.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        untilSuccessful.setMaxRetries(2);
        if (millisBetweenRetries != null) {
            untilSuccessful.setMillisBetweenRetries(millisBetweenRetries.longValue());
        }
        this.objectStore = new SimpleMemoryObjectStore();
        untilSuccessful.setObjectStore(this.objectStore);
        this.targetMessageProcessor = new ConfigurableMessageProcessor();
        untilSuccessful.addRoute((Processor)this.targetMessageProcessor);
        return untilSuccessful;
    }

    protected void doTearDown() throws Exception {
        this.untilSuccessful.stop();
    }

    @Test
    public void testSuccessfulDelivery() throws Exception {
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertSame((Object)this.testEvent(), (Object)this.untilSuccessful.process(this.testEvent()));
        this.ponderUntilEventProcessed(this.testEvent());
    }

    @Test
    public void testSuccessfulDeliveryStreamPayload() throws Exception {
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Event testEvent = UntilSuccessfulTestCase.eventBuilder().message(Message.of((Object)new ByteArrayInputStream("test_data".getBytes()))).build();
        Assert.assertSame((Object)testEvent, (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
    }

    @Test
    public void testSuccessfulDeliveryAckExpression() throws Exception {
        this.untilSuccessful.setAckExpression("#[mel:'ACK']");
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.setFlowConstruct((FlowConstruct)this.mockFlow);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertThat((Object)this.untilSuccessful.process(this.testEvent()).getMessageAsString(muleContext), (Matcher)CoreMatchers.equalTo((Object)"ACK"));
        this.waitDelivery();
    }

    @Test
    public void testSuccessfulDeliveryFailureExpression() throws Exception {
        this.untilSuccessful.setFailureExpression("#[mel:regex('(?i)error')]");
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertSame((Object)this.testEvent(), (Object)this.untilSuccessful.process(this.testEvent()));
        this.ponderUntilEventProcessed(this.testEvent());
    }

    @Test
    public void testPermanentDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(Integer.MAX_VALUE);
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Event testEvent = UntilSuccessfulTestCase.eventBuilder().message(Message.of((Object)"ERROR")).build();
        Assert.assertSame((Object)testEvent, (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
    }

    @Test
    public void testPermanentDeliveryFailureExpression() throws Exception {
        this.untilSuccessful.setFailureExpression("#[mel:regex('(?i)error')]");
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Event testEvent = UntilSuccessfulTestCase.eventBuilder().message(Message.of((Object)"ERROR")).build();
        Assert.assertSame((Object)testEvent, (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
    }

    @Test
    public void testTemporaryDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(this.untilSuccessful.getMaxRetries());
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Event testEvent = UntilSuccessfulTestCase.eventBuilder().message(Message.of((Object)"ERROR")).build();
        Assert.assertSame((Object)testEvent, (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
        Assert.assertEquals((long)this.targetMessageProcessor.getEventCount(), (long)(this.untilSuccessful.getMaxRetries() + 1));
    }

    @Test
    public void testPreExistingEvents() throws Exception {
        new AsynchronousUntilSuccessfulProcessingStrategy();
        this.objectStore.store(AsynchronousUntilSuccessfulProcessingStrategy.buildQueueKey((Event)this.testEvent(), (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (MuleContext)muleContext), (Serializable)this.testEvent());
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        muleContext.start();
        this.ponderUntilEventProcessed(this.testEvent());
    }

    @Test
    public void testDefaultMillisWait() throws Exception {
        this.untilSuccessful = this.buildUntiSuccessful(null);
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertEquals((long)60000L, (long)this.untilSuccessful.getMillisBetweenRetries());
    }

    @Test
    public void testMillisWait() throws Exception {
        long millis = 10L;
        this.untilSuccessful.setMillisBetweenRetries(10L);
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertEquals((long)10L, (long)this.untilSuccessful.getMillisBetweenRetries());
    }

    @Test
    public void testSecondsWait() throws Exception {
        long seconds = 10L;
        this.untilSuccessful = this.buildUntiSuccessful(null);
        this.untilSuccessful.setSecondsBetweenRetries(10L);
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertEquals((long)10000L, (long)this.untilSuccessful.getMillisBetweenRetries());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMillisAndSecondsWait() throws Exception {
        this.untilSuccessful.setMillisBetweenRetries(1000L);
        this.untilSuccessful.setSecondsBetweenRetries(1000L);
        this.untilSuccessful.initialise();
    }

    private void ponderUntilEventProcessed(Event testEvent) throws InterruptedException, MuleException {
        this.waitDelivery();
        this.assertLogicallyEqualEvents(testEvent, this.targetMessageProcessor.getEventReceived());
    }

    private void waitDelivery() {
        this.pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                return UntilSuccessfulTestCase.this.targetMessageProcessor.getEventReceived() != null && UntilSuccessfulTestCase.this.objectStore.allKeys().isEmpty();
            }

            public String describeFailure() {
                return "Event not received by target";
            }
        });
    }

    private void ponderUntilEventAborted(Event testEvent) throws InterruptedException, MuleException {
        this.pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                return UntilSuccessfulTestCase.this.targetMessageProcessor.getEventCount() > UntilSuccessfulTestCase.this.untilSuccessful.getMaxRetries() && UntilSuccessfulTestCase.this.objectStore.allKeys().isEmpty();
            }

            public String describeFailure() {
                return String.format("Processing not retried %s times.", UntilSuccessfulTestCase.this.untilSuccessful.getMaxRetries());
            }
        });
        Assert.assertEquals((long)0L, (long)this.objectStore.allKeys().size());
        Assert.assertEquals((long)this.targetMessageProcessor.getEventCount(), (long)(1 + this.untilSuccessful.getMaxRetries()));
    }

    private void assertLogicallyEqualEvents(Event testEvent, Event eventReceived) throws MuleException {
        Assert.assertEquals((Object)testEvent.getCorrelationId(), (Object)eventReceived.getCorrelationId());
        Assert.assertEquals((Object)testEvent.getMessageAsString(muleContext), (Object)eventReceived.getMessageAsString(muleContext));
    }

    public static class ConfigurableMessageProcessor
    implements Processor {
        private volatile int eventCount;
        private volatile Event event;
        private volatile int numberOfFailuresToSimulate;

        public Event process(Event evt) throws MuleException {
            ++this.eventCount;
            if (this.numberOfFailuresToSimulate-- > 0) {
                throw new RuntimeException("simulated problem");
            }
            this.event = evt;
            return evt;
        }

        public Event getEventReceived() {
            return this.event;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public void setNumberOfFailuresToSimulate(int numberOfFailuresToSimulate) {
            this.numberOfFailuresToSimulate = numberOfFailuresToSimulate;
        }
    }
}

