/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.routing.WireTap;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class WireTapTestCase
extends AbstractMuleContextTestCase {
    protected SensingNullMessageProcessor tapListener;
    protected WireTap wireTap;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.wireTap = new WireTap();
        this.tapListener = this.getSensingNullMessageProcessor();
        this.wireTap.setTap((Processor)this.tapListener);
    }

    @Test
    public void testWireTapNoFilter() throws Exception {
        Event primaryOutput = this.wireTap.process(this.testEvent());
        Assert.assertSame((Object)this.testEvent(), (Object)primaryOutput);
        Assert.assertNotNull((Object)this.tapListener.event);
        Assert.assertThat((Object)this.tapListener.event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)this.testEvent().getMessage().getPayload().getValue()));
    }

    @Test
    public void testWireTapFilterAccepted() throws Exception {
        this.wireTap.setFilter((message, builder) -> true);
        Event primaryOutput = this.wireTap.process(this.testEvent());
        Assert.assertSame((Object)this.testEvent(), (Object)primaryOutput);
        Assert.assertNotNull((Object)this.tapListener.event);
        Assert.assertThat((Object)this.tapListener.event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)this.testEvent().getMessage().getPayload().getValue()));
    }

    @Test
    public void testWireTapFilterUnaccepted() throws Exception {
        this.wireTap.setFilter((message, builder) -> false);
        Event primaryOutput = this.wireTap.process(this.testEvent());
        Assert.assertSame((Object)this.testEvent(), (Object)primaryOutput);
        Assert.assertNull((Object)this.tapListener.event);
    }

    @Test
    public void testWireTapNullTap() throws Exception {
        this.wireTap.setTap(null);
        Event primaryOutput = this.wireTap.process(this.testEvent());
        Assert.assertSame((Object)this.testEvent(), (Object)primaryOutput);
    }
}

