/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.io.ByteArrayInputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.routing.filters.ConsumableMuleMessageFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ConsumableFilterTestCase
extends AbstractMuleTestCase {
    private ConsumableMuleMessageFilter filter;

    @Before
    public void setUp() throws Exception {
        this.filter = new ConsumableMuleMessageFilter();
    }

    @Test
    public void testRejectsConsumablePayload() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("TEST".getBytes());
        Message message = Message.of((Object)is);
        Assert.assertThat((String)"Should reject consumable payload", (Object)this.filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testAcceptsNonConsumablePayload() throws Exception {
        Message message = Message.of((Object)"TEST");
        Assert.assertThat((String)"Should accept non consumable payload", (Object)this.filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)true));
    }
}

