/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.io.IOException;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.filters.ExceptionTypeFilter;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ExceptionTypeFilterTestCase
extends AbstractMuleTestCase {
    @Test
    public void testExceptionTypeFilterMessage() {
        ExceptionTypeFilter filter = new ExceptionTypeFilter();
        Assert.assertThat((Object)filter.getExpectedType(), (Matcher)IsNull.nullValue());
        Message m = Message.of((Object)"test");
        Assert.assertThat((Object)filter.accept(m, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)false));
        m = InternalMessage.builder((Message)m).exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IllegalArgumentException("test"))).build();
        Assert.assertThat((Object)filter.accept(m, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)true));
        filter = new ExceptionTypeFilter(IOException.class);
        Assert.assertThat((Object)filter.accept(m, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)false));
        m = InternalMessage.builder((Message)m).exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IOException("test"))).build();
        Assert.assertThat((Object)filter.accept(m, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testExceptionTypeFilterEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        ExceptionTypeFilter filter = new ExceptionTypeFilter();
        Assert.assertThat((Object)filter.getExpectedType(), (Matcher)IsNull.nullValue());
        Message m = Message.of((Object)"test");
        Assert.assertThat((Object)filter.accept(m, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)false));
        Exception exception = new IllegalArgumentException("test");
        Error mockError = MuleTestUtils.createErrorMock((Exception)exception);
        Mockito.when((Object)event.getError()).thenReturn(Optional.of(mockError));
        m = InternalMessage.builder((Message)m).build();
        Assert.assertThat((Object)filter.accept(event, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)true));
        Mockito.when((Object)event.getMessage()).thenReturn((Object)m);
        Mockito.when((Object)event.getError()).thenReturn(Optional.empty());
        filter = new ExceptionTypeFilter(IOException.class);
        Assert.assertThat((Object)filter.accept(event, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)false));
        exception = new IOException("test");
        mockError = MuleTestUtils.createErrorMock((Exception)exception);
        Mockito.when((Object)event.getError()).thenReturn(Optional.of(mockError));
        Assert.assertThat((Object)filter.accept(event, (Event.Builder)Mockito.mock(Event.Builder.class)), (Matcher)Is.is((Object)true));
    }
}

