/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.io.IOException;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.filters.ExpressionFilter;
import org.mule.runtime.core.routing.filters.RegExFilter;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class ExpressionFilterTestCase
extends AbstractMuleContextTestCase {
    private Event.Builder eventBuilder;

    @Before
    public void before() throws MuleException {
        this.eventBuilder = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION));
    }

    @Test
    public void testHeaderFilterEL() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("mel:message.outboundProperties['foo']=='bar'");
        filter.setMuleContext(muleContext);
        Message message = Message.of((Object)"blah");
        Assert.assertTrue((!filter.accept(message, this.eventBuilder) ? 1 : 0) != 0);
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertTrue((boolean)filter.accept(message, this.eventBuilder));
    }

    @Test
    public void testVariableFilterEL() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("mel:flowVars['foo']=='bar'");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((!filter.accept(this.testEvent(), this.eventBuilder) ? 1 : 0) != 0);
        Event event = Event.builder((Event)this.testEvent()).addVariable("foo", (Object)"bar").build();
        Assert.assertTrue((boolean)filter.accept(event, this.eventBuilder));
    }

    @Test
    public void testHeaderFilterWithNotEL() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("mel:message.outboundProperties['foo']!='bar'");
        filter.setMuleContext(muleContext);
        Message message = Message.of((Object)"blah");
        Assert.assertTrue((boolean)filter.accept(message, this.eventBuilder));
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertTrue((!filter.accept(message, this.eventBuilder) ? 1 : 0) != 0);
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"car")).build();
        Assert.assertTrue((boolean)filter.accept(message, this.eventBuilder));
    }

    @Test
    public void testVariableFilterWithNotEL() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("mel:flowVars['foo']!='bar'");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((boolean)filter.accept(this.testEvent(), this.eventBuilder));
        Event event = Event.builder((Event)this.testEvent()).addVariable("foo", (Object)"bar").build();
        Assert.assertTrue((!filter.accept(event, this.eventBuilder) ? 1 : 0) != 0);
        event = Event.builder((Event)event).addVariable("foo", (Object)"car").build();
        Assert.assertTrue((boolean)filter.accept(event, this.eventBuilder));
    }

    private Message removeProperty(Message message) {
        return InternalMessage.builder((Message)message).removeOutboundProperty("foo").build();
    }

    @Test
    public void testHeaderFilterWithNotNullEL() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("mel:message.outboundProperties['foo']!=null");
        filter.setMuleContext(muleContext);
        Message message = Message.of((Object)"blah");
        Assert.assertTrue((!filter.accept(message, this.eventBuilder) ? 1 : 0) != 0);
        message = this.removeProperty(message);
        Assert.assertTrue((!filter.accept(message, this.eventBuilder) ? 1 : 0) != 0);
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"car")).build();
        Assert.assertTrue((boolean)filter.accept(message, this.eventBuilder));
    }

    @Test
    public void testVariableFilterWithNotNullEL() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("mel:flowVars['foo']!=null");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((!filter.accept(this.testEvent(), this.eventBuilder) ? 1 : 0) != 0);
        Event event = Event.builder((Event)this.testEvent()).message(this.removeProperty(this.testEvent().getMessage())).build();
        Assert.assertTrue((!filter.accept(event, this.eventBuilder) ? 1 : 0) != 0);
        event = Event.builder((Event)event).addVariable("foo", (Object)"car").build();
        Assert.assertTrue((boolean)filter.accept(event, this.eventBuilder));
    }

    @Test
    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        Assert.assertNull((Object)filter.getPattern());
        Assert.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern("(.*) brown fox");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        Assert.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    @Test
    public void testRegexFilterWithAngleBrackets() {
        ExpressionFilter filter = new ExpressionFilter("#[mel:regex('The number is [1-9]')]");
        filter.setMuleContext(muleContext);
        Assert.assertNotNull((Object)filter.getExpression());
        Assert.assertTrue((boolean)filter.accept(Message.of((Object)"The number is 4"), this.eventBuilder));
        Assert.assertFalse((boolean)filter.accept(Message.of((Object)"Say again?"), this.eventBuilder));
        Assert.assertFalse((boolean)filter.accept(Message.of((Object)"The number is 0"), this.eventBuilder));
    }

    @Test
    public void testExceptionTypeFilter() {
        ExpressionFilter filter = new ExpressionFilter("mel:exception.getCause() is java.lang.Exception");
        filter.setMuleContext(muleContext);
        Message m = Message.of((Object)"test");
        m = InternalMessage.builder((Message)m).exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IllegalArgumentException("test"))).build();
        Assert.assertTrue((boolean)filter.accept(m, this.eventBuilder));
        filter = new ExpressionFilter("mel:exception.getCause() is java.io.IOException");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((!filter.accept(m, this.eventBuilder) ? 1 : 0) != 0);
        m = InternalMessage.builder((Message)m).exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IOException("test"))).build();
        Assert.assertTrue((boolean)filter.accept(m, this.eventBuilder));
    }

    @Test
    public void testExceptionTypeFilterEL() {
        ExpressionFilter filter = new ExpressionFilter("mel:exception.getCause() is java.lang.Exception");
        filter.setMuleContext(muleContext);
        Message m = Message.of((Object)"test");
        m = InternalMessage.builder((Message)m).exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IllegalArgumentException("test"))).build();
        Assert.assertTrue((boolean)filter.accept(m, this.eventBuilder));
        filter = new ExpressionFilter("mel:exception.getCause() is java.io.IOException");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((!filter.accept(m, this.eventBuilder) ? 1 : 0) != 0);
        m = InternalMessage.builder((Message)m).exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IOException("test"))).build();
        Assert.assertTrue((boolean)filter.accept(m, this.eventBuilder));
    }

    @Test
    public void testPayloadTypeFilterEL() {
        ExpressionFilter filter = new ExpressionFilter("mel:payload is org.mule.tck.testmodels.fruit.Apple");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((boolean)filter.accept(Message.of((Object)new Apple()), this.eventBuilder));
        Assert.assertTrue((!filter.accept(Message.of((Object)"test"), this.eventBuilder) ? 1 : 0) != 0);
        filter = new ExpressionFilter("mel:payload is String");
        filter.setMuleContext(muleContext);
        Assert.assertTrue((boolean)filter.accept(Message.of((Object)"test"), this.eventBuilder));
        Assert.assertTrue((!filter.accept(Message.of((Object)new Exception("test")), this.eventBuilder) ? 1 : 0) != 0);
    }

    @Test
    public void testTrueStringEL() {
        ExpressionFilter filter = new ExpressionFilter("payload");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(true);
        Assert.assertTrue((boolean)filter.accept(Message.of((Object)"true"), this.eventBuilder));
        Assert.assertTrue((boolean)filter.accept(Message.of((Object)"TRUE"), this.eventBuilder));
        Assert.assertTrue((boolean)filter.accept(Message.of((Object)"tRuE"), this.eventBuilder));
    }

    @Test
    public void testFalseStringEL() {
        ExpressionFilter filter = new ExpressionFilter("payload");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        Assert.assertFalse((boolean)filter.accept(Message.of((Object)"false"), this.eventBuilder));
        Assert.assertFalse((boolean)filter.accept(Message.of((Object)"FALSE"), this.eventBuilder));
        Assert.assertFalse((boolean)filter.accept(Message.of((Object)"faLSe"), this.eventBuilder));
    }
}

