/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.routing.filters.EqualsFilter;
import org.mule.runtime.core.routing.filters.WildcardFilter;
import org.mule.runtime.core.routing.filters.logic.AndFilter;
import org.mule.runtime.core.routing.filters.logic.NotFilter;
import org.mule.runtime.core.routing.filters.logic.OrFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class LogicFiltersTestCase
extends AbstractMuleTestCase {
    @Test
    public void testAndFilter() {
        AndFilter filter = new AndFilter();
        Assert.assertEquals((long)0L, (long)filter.getFilters().size());
        Assert.assertFalse((boolean)filter.accept((Object)"foo"));
        filter.getFilters().add(new EqualsFilter((Object)"foo"));
        Assert.assertTrue((boolean)filter.accept((Object)"foo"));
        filter.getFilters().add(new EqualsFilter((Object)"foo"));
        Assert.assertFalse((boolean)filter.accept((Object)"bar"));
        Assert.assertTrue((boolean)filter.accept((Object)"foo"));
        WildcardFilter left = new WildcardFilter("blah.blah.*");
        WildcardFilter right = new WildcardFilter("blah.*");
        filter = new AndFilter(new Filter[]{left, right});
        Assert.assertEquals((long)2L, (long)filter.getFilters().size());
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah.blah"));
        Assert.assertTrue((boolean)right.accept((Object)"blah.blah"));
        Assert.assertTrue((!left.accept((Object)"blah.blah") ? 1 : 0) != 0);
        Assert.assertTrue((!filter.accept((Object)"blah.blah") ? 1 : 0) != 0);
        filter = new AndFilter();
        filter.getFilters().add(left);
        filter.getFilters().add(right);
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah.blah"));
        Assert.assertTrue((!filter.accept((Object)"blah.blah") ? 1 : 0) != 0);
    }

    @Test
    public void testOrFilter() {
        OrFilter filter = new OrFilter();
        Assert.assertEquals((long)0L, (long)filter.getFilters().size());
        Assert.assertFalse((boolean)filter.accept((Object)"foo"));
        WildcardFilter left = new WildcardFilter("blah.blah.*");
        WildcardFilter right = new WildcardFilter("blah.b*");
        filter = new OrFilter(new Filter[]{left, right});
        Assert.assertEquals((long)2L, (long)filter.getFilters().size());
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah.blah"));
        Assert.assertTrue((boolean)right.accept((Object)"blah.blah"));
        Assert.assertTrue((!left.accept((Object)"blah.blah") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah"));
        Assert.assertTrue((!filter.accept((Object)"blah.x.blah") ? 1 : 0) != 0);
        filter = new OrFilter();
        LinkedList<WildcardFilter> filters = new LinkedList<WildcardFilter>();
        filters.addLast(left);
        filters.addLast(right);
        filter.setFilters(filters);
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah.blah"));
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah"));
        Assert.assertTrue((!filter.accept((Object)"blah.x.blah") ? 1 : 0) != 0);
    }

    @Test
    public void testNotFilter() {
        NotFilter notFilter = new NotFilter();
        Assert.assertNull((Object)notFilter.getFilter());
        Assert.assertFalse((boolean)notFilter.accept((Object)"foo"));
        Assert.assertFalse((boolean)notFilter.accept(null));
        WildcardFilter filter = new WildcardFilter("blah.blah.*");
        notFilter = new NotFilter((Filter)filter);
        Assert.assertNotNull((Object)notFilter.getFilter());
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah.blah"));
        Assert.assertTrue((!notFilter.accept((Object)"blah.blah.blah") ? 1 : 0) != 0);
        notFilter = new NotFilter();
        notFilter.setFilter((Filter)filter);
        Assert.assertTrue((boolean)filter.accept((Object)"blah.blah.blah"));
        Assert.assertTrue((!notFilter.accept((Object)"blah.blah.blah") ? 1 : 0) != 0);
    }
}

