/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.io.Serializable;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.filters.MessagePropertyFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MessagePropertyFilterTestCase
extends AbstractMuleTestCase {
    @Test
    public void testMessagePropertyFilter() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=bar");
        Message message = Message.of((Object)"blah");
        Assert.assertTrue((!filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)) ? 1 : 0) != 0);
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyFilterInboundScope() throws Exception {
        Message message = Message.of((Object)"blah");
        MessagePropertyFilter filter = new MessagePropertyFilter("inbound:foo=bar");
        Assert.assertEquals((Object)"inbound", (Object)filter.getScope());
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyFilterWithURL() throws Exception {
        Message message = Message.of((Object)"blah");
        MessagePropertyFilter filter = new MessagePropertyFilter("inbound:foo=http://foo.com");
        Assert.assertEquals((Object)"inbound", (Object)filter.getScope());
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        HashMap<String, String> inboundProps = new HashMap<String, String>();
        inboundProps.put("foo", "http://foo.com");
        message = InternalMessage.builder().payload((Object)"blah").inboundProperties(inboundProps).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        filter = new MessagePropertyFilter("bar=http://bar.com");
        Assert.assertEquals((Object)"outbound", (Object)filter.getScope());
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = InternalMessage.builder((Message)message).addOutboundProperty("bar", (Serializable)((Object)"http://bar.com")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyFilterWithNot() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=bar");
        Message message = Message.of((Object)"blah");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"car")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyFilterWithNotNull() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        Message message = Message.of((Object)"blah");
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = this.removeProperty((InternalMessage)message, "foo");
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"car")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyFilterWithCaseSensitivity() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=Bar");
        Message message = Message.of((Object)"blah");
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        filter.setCaseSensitive(false);
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyFilterWithWildcard() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=B*");
        Message message = Message.of((Object)"blah");
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        filter.setCaseSensitive(false);
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        filter.setPattern("foo=*a*");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyFilterDodgyValues() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter();
        Assert.assertFalse((boolean)filter.accept((Message)((InternalMessage)null), (Event.Builder)Mockito.mock(Event.Builder.class)));
        filter = new MessagePropertyFilter("foo = bar");
        Message message = Message.of((Object)"blah");
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        filter.setCaseSensitive(false);
        filter = new MessagePropertyFilter("foo2 =null");
        message = this.removeProperty((InternalMessage)message, "foo2");
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        filter = new MessagePropertyFilter("foo2 =");
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo2", (Serializable)((Object)"")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = this.removeProperty((InternalMessage)message, "foo2");
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    private Message removeProperty(InternalMessage message, String property) {
        return InternalMessage.builder((Message)message).removeOutboundProperty(property).build();
    }

    @Test
    public void testMessagePropertyFilterPropertyExists() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        Message message = Message.of((Object)"blah");
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)((Object)"car")).build();
        Assert.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testMessagePropertyWithEnum() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=ONE_WAY");
        Message message = Message.of((Object)"");
        Assert.assertFalse((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
        message = InternalMessage.builder((Message)message).addOutboundProperty("foo", (Serializable)MessageExchangePattern.ONE_WAY).build();
        Assert.assertTrue((boolean)filter.accept(message, (Event.Builder)Mockito.mock(Event.Builder.class)));
    }
}

