/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.source.polling;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.source.polling.PeriodicScheduler;
import org.mule.runtime.core.source.scheduler.DefaultSchedulerMessageSource;
import org.mule.runtime.core.source.scheduler.schedule.FixedFrequencyScheduler;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerMessageSourceTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSchedulerMessageSourceTestCase.class);
    private DefaultSchedulerMessageSource schedulerMessageSource;

    @Test
    public void simplePoll() throws Exception {
        DefaultSchedulerMessageSource schedulerMessageSource = this.createMessageSource();
        final SensingNullMessageProcessor flow = this.getSensingNullMessageProcessor();
        schedulerMessageSource.setListener((Processor)flow);
        schedulerMessageSource.setAnnotations(Collections.singletonMap(AbstractAnnotatedObject.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        schedulerMessageSource.trigger();
        new PollingProber(5000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                return flow.event != null;
            }

            public String describeFailure() {
                return "flow event never set by the source flow";
            }
        });
    }

    @Test
    public void disposeScheduler() throws Exception {
        Mockito.reset((Object[])new SchedulerService[]{muleContext.getSchedulerService()});
        DefaultSchedulerMessageSource schedulerMessageSource = this.createMessageSource();
        ((SchedulerService)Mockito.verify((Object)muleContext.getSchedulerService())).cpuLightScheduler();
        List createdSchedulers = muleContext.getSchedulerService().getSchedulers();
        schedulerMessageSource.start();
        Scheduler pollScheduler = (Scheduler)createdSchedulers.get(createdSchedulers.size() - 1);
        ((Scheduler)Mockito.verify((Object)pollScheduler)).scheduleAtFixedRate((Runnable)Matchers.any(), Matchers.anyLong(), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()));
        schedulerMessageSource.stop();
        schedulerMessageSource.dispose();
        ((Scheduler)Mockito.verify((Object)pollScheduler)).stop();
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.schedulerMessageSource);
        LifecycleUtils.disposeIfNeeded((Object)this.schedulerMessageSource, (Logger)LOGGER);
    }

    private DefaultSchedulerMessageSource createMessageSource() throws Exception {
        this.schedulerMessageSource = new DefaultSchedulerMessageSource(muleContext, (PeriodicScheduler)this.scheduler());
        this.schedulerMessageSource.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        this.schedulerMessageSource.initialise();
        return this.schedulerMessageSource;
    }

    private FixedFrequencyScheduler scheduler() {
        FixedFrequencyScheduler factory = new FixedFrequencyScheduler();
        factory.setFrequency(1000L);
        return factory;
    }
}

