/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.streaming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.internal.streaming.object.iterator.CompositeProducer;
import org.mule.runtime.core.internal.streaming.object.iterator.Producer;
import org.mule.tck.size.SmallTest;
import ru.yandex.qatools.allure.annotations.Features;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
@Features(value={"Streaming"})
public class CompositeProducerTestCase {
    private List<String> list1;
    private List<String> list2;
    private List<String> list3;
    private List<String> aggregatedList;
    @Mock
    private Producer<List<String>> producer1;
    @Mock
    private Producer<List<String>> producer2;
    private CompositeProducer<List<String>> producer;

    @Before
    public void setUp() throws Exception {
        this.list1 = Arrays.asList("superman", "batman");
        this.list2 = Arrays.asList("iron man", "hulk");
        this.list3 = Arrays.asList("paturuzu", "eternauta");
        this.aggregatedList = new ArrayList<String>();
        this.aggregatedList.addAll(this.list1);
        this.aggregatedList.addAll(this.list2);
        this.aggregatedList.addAll(this.list3);
        Mockito.when((Object)this.producer1.produce()).thenReturn(this.list1).thenReturn(this.list2).thenReturn(null);
        Mockito.when((Object)this.producer1.getSize()).thenReturn((Object)(this.list1.size() + this.list2.size()));
        Mockito.when((Object)this.producer2.produce()).thenReturn(this.list3).thenReturn(null);
        Mockito.when((Object)this.producer2.getSize()).thenReturn((Object)this.list3.size());
        this.producer = new CompositeProducer(new Producer[]{this.producer1, this.producer2});
    }

    @Test
    public void consumeAndClose() throws Exception {
        ArrayList output = new ArrayList();
        List page = (List)this.producer.produce();
        output.addAll(page);
        while (!CollectionUtils.isEmpty((Collection)page)) {
            page = (List)this.producer.produce();
            if (page == null) continue;
            output.addAll(page);
        }
        Assert.assertEquals((int)output.size(), (int)this.aggregatedList.size());
        for (int i = 0; i < this.aggregatedList.size(); ++i) {
            Assert.assertEquals((String)((String)output.get(i)), (String)this.aggregatedList.get(i));
        }
    }

    @Test
    public void close() throws Exception {
        this.producer.close();
        ((Producer)Mockito.verify(this.producer1)).close();
        ((Producer)Mockito.verify(this.producer2)).close();
    }

    @Test
    public void totalAvailable() {
        Assert.assertEquals((int)this.aggregatedList.size(), (int)this.producer.getSize());
    }
}

