/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.streaming;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import ru.yandex.qatools.allure.annotations.Description;

public abstract class InMemoryStreamingConfigContractTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    @Description(value="Test that a valid config is indeed valid")
    public void initialSizeEqualsMaxSizeWithNoExpansion() {
        this.assertValid(1, 0, 1);
    }

    @Test
    @Description(value="initial size of zero should be invalid")
    public void zeroInitialSize() {
        this.assertInvalid(0, 1, 10);
    }

    @Test
    @Description(value="initial size cannot be negative")
    public void negativeInitialSIze() {
        this.assertInvalid(-1, 1, 10);
    }

    @Test
    @Description(value="increment size cannot be negative")
    public void negativeIncrementSize() {
        this.assertInvalid(10, -1, 20);
    }

    @Test
    @Description(value="initial size cannot be bigger the maxSize")
    public void initialSizeBiggerThanMaxSize() {
        this.assertInvalid(100, 1, 10);
    }

    @Test
    @Description(value="incrementSize cannot be bigger than the maxSize")
    public void incrementSizeBiggerThanMaxSize() {
        this.assertInvalid(10, 100, 20);
    }

    @Test
    @Description(value="initialSize + incrementSize cannot be bigger than maxSize")
    public void invalidExpansionSize() {
        this.assertInvalid(1, 100, 100);
    }

    private void assertValid(int initialSize, int increment, int maxSize) {
        this.createConfig(initialSize, increment, maxSize);
    }

    private void assertInvalid(int initialSize, int increment, int maxSize) {
        this.expectedException.expect(IllegalArgumentException.class);
        this.createConfig(initialSize, increment, maxSize);
    }

    protected abstract void createConfig(int var1, int var2, int var3);
}

