/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.internal.streaming.object.iterator.ClosedConsumerException;
import org.mule.runtime.core.internal.streaming.object.iterator.Consumer;
import org.mule.runtime.core.internal.streaming.object.iterator.ListConsumer;
import org.mule.runtime.core.internal.streaming.object.iterator.Producer;
import org.mule.tck.size.SmallTest;
import ru.yandex.qatools.allure.annotations.Features;

@SmallTest
@Features(value={"Streaming"})
public class ListConsumerTestCase {
    private static final int totalCount = 50;
    private static final int pageSize = 10;
    private Consumer<Integer> consumer;
    private Producer<List<Integer>> producer;
    private List<List<Integer>> pages;

    @Before
    public void setUp() {
        this.pages = this.getPages();
        this.producer = (Producer)Mockito.spy((Object)new TestProducer());
        this.consumer = (Consumer)Mockito.spy((Object)new ListConsumer(this.producer));
    }

    @Test(expected=ClosedConsumerException.class)
    public void happyPath() throws Exception {
        ArrayList<Object> elements = new ArrayList<Object>();
        while (!this.consumer.isConsumed()) {
            elements.add(this.consumer.consume());
        }
        Assert.assertEquals((long)elements.size(), (long)50L);
        Assert.assertTrue((boolean)this.consumer.isConsumed());
        for (List<Integer> page : this.pages) {
            Assert.assertTrue((boolean)elements.containsAll(page));
        }
        ((Consumer)Mockito.verify(this.consumer)).close();
        ((Producer)Mockito.verify(this.producer)).close();
        this.consumer.consume();
    }

    @Test(expected=ClosedConsumerException.class)
    public void closeEarly() throws Exception {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < 10; ++i) {
            elements.add(this.consumer.consume());
        }
        this.consumer.close();
        Assert.assertEquals((long)10L, (long)elements.size());
        Assert.assertTrue((boolean)elements.containsAll((Collection)this.pages.get(0)));
        Assert.assertTrue((boolean)this.consumer.isConsumed());
        this.consumer.consume();
    }

    @Test
    public void totalAvailable() {
        Assert.assertEquals((long)this.consumer.getSize(), (long)50L);
    }

    @Test
    public void doubleClose() throws Exception {
        this.consumer.close();
        this.consumer.close();
    }

    private List<List<Integer>> getPages() {
        ArrayList<List<Integer>> pages = new ArrayList<List<Integer>>();
        ArrayList<Integer> page = new ArrayList<Integer>();
        for (int i = 1; i <= 50; ++i) {
            page.add(i);
            if (i % 10 != 0) continue;
            pages.add(page);
            page = new ArrayList();
        }
        return pages;
    }

    private class TestProducer
    implements Producer<List<Integer>> {
        private int index = 0;

        private TestProducer() {
        }

        public void close() throws IOException {
        }

        public List<Integer> produce() {
            List<Integer> ret;
            if (this.index < ListConsumerTestCase.this.pages.size()) {
                ret = (List)ListConsumerTestCase.this.pages.get(this.index);
                ++this.index;
            } else {
                ret = new ArrayList<Integer>();
            }
            return ret;
        }

        public int getSize() {
            return 50;
        }
    }
}

