/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.transaction.IllegalTransactionStateException;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.mule.TestTransaction;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class TransactionCoordinationTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext;
    private TransactionCoordination tc;

    @Before
    public void setUpTransaction() throws Exception {
        this.tc = TransactionCoordination.getInstance();
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.muleContext.getConfiguration().getId()).thenReturn((Object)"appName");
    }

    @After
    public void unbindTransaction() throws Exception {
        this.tc.unbindTransaction(this.tc.getTransaction());
    }

    @Test
    public void testBindTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        Assert.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testBindTransactionWithAlreadyBound() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        Assert.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        try {
            Transaction tx2 = (Transaction)Mockito.mock(Transaction.class);
            this.tc.bindTransaction(tx2);
            Assert.fail();
        }
        catch (IllegalTransactionStateException illegalTransactionStateException) {
            // empty catch block
        }
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testUnbindTransactionWithoutBound() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testSetInstanceWithBound() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testCommitCurrentTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.commitCurrentTransaction();
        TestTransaction testTransaction = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        this.tc.bindTransaction((Transaction)testTransaction);
        this.tc.commitCurrentTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)Mockito.verify((Object)testTransaction, (VerificationMode)VerificationModeFactory.times((int)1))).commit();
    }

    @Test
    public void testCommitCurrentTransactionWithSuspendedTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction xaTx = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        xaTx.setXA(true);
        Transaction tx = (Transaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        this.tc.bindTransaction((Transaction)xaTx);
        this.tc.suspendCurrentTransaction();
        this.tc.bindTransaction(tx);
        this.tc.commitCurrentTransaction();
        this.tc.resumeSuspendedTransaction();
        Assert.assertThat((Object)((TestTransaction)this.tc.getTransaction()), (Matcher)Is.is((Object)xaTx));
        ((TestTransaction)Mockito.verify((Object)xaTx, (VerificationMode)VerificationModeFactory.times((int)1))).suspend();
        ((TestTransaction)Mockito.verify((Object)xaTx, (VerificationMode)VerificationModeFactory.times((int)1))).resume();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).commit();
    }

    @Test
    public void testCommitDoesntFailOnException() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doThrow((Throwable)new TransactionException((Throwable)null)).when((Object)tx)).commit();
        TransactionCoordination.getInstance().commitCurrentTransaction();
    }

    @Test
    public void testRollbackCurrentTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.commitCurrentTransaction();
        TestTransaction testTransaction = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        this.tc.bindTransaction((Transaction)testTransaction);
        this.tc.rollbackCurrentTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)Mockito.verify((Object)testTransaction, (VerificationMode)VerificationModeFactory.times((int)1))).rollback();
    }

    @Test
    public void testRollbackCurrentTransactionWithSuspendedTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction xaTx = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        xaTx.setXA(true);
        Transaction tx = (Transaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        this.tc.bindTransaction((Transaction)xaTx);
        this.tc.suspendCurrentTransaction();
        this.tc.bindTransaction(tx);
        this.tc.rollbackCurrentTransaction();
        this.tc.resumeSuspendedTransaction();
        Assert.assertThat((Object)((TestTransaction)this.tc.getTransaction()), (Matcher)Is.is((Object)xaTx));
        ((TestTransaction)Mockito.verify((Object)xaTx, (VerificationMode)VerificationModeFactory.times((int)1))).suspend();
        ((TestTransaction)Mockito.verify((Object)xaTx, (VerificationMode)VerificationModeFactory.times((int)1))).resume();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).rollback();
    }

    @Test
    public void testRollbackDoesntFailOnException() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doThrow((Throwable)new TransactionException((Throwable)null)).when((Object)tx)).rollback();
        TransactionCoordination.getInstance().rollbackCurrentTransaction();
    }

    @Test
    public void testSuspendResumeTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        this.tc.suspendCurrentTransaction();
        Assert.assertNull((Object)this.tc.getTransaction());
        this.tc.resumeSuspendedTransaction();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).suspend();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).resume();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)Is.is((Object)tx));
    }

    @Test
    public void testResumeXaTransactionIfAvailableWithNoTx() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.resumeXaTransactionIfAvailable();
        Transaction tx = (Transaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        this.tc.bindTransaction(tx);
        this.tc.resumeXaTransactionIfAvailable();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)0))).resume();
    }

    @Test
    public void testResumeXaTransactionIfAvailableWithTx() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.resumeXaTransactionIfAvailable();
        TestTransaction tx = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        this.tc.suspendCurrentTransaction();
        this.tc.resumeXaTransactionIfAvailable();
        ((TestTransaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).suspend();
        ((TestTransaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).resume();
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testResumeXaTransactionTwice() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction tx = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        this.tc.resumeSuspendedTransaction();
        this.tc.resumeSuspendedTransaction();
    }

    @Test
    public void testResolveTransactionForRollback() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction tx = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        tx.setRollbackOnly();
        this.tc.resolveTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).rollback();
    }

    @Test
    public void testResolveTransactionForCommit() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction tx = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        this.tc.resolveTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).commit();
    }
}

