/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.api.context.notification.TransactionNotificationListener;
import org.mule.runtime.core.context.notification.TransactionNotification;
import org.mule.runtime.core.transaction.AbstractSingleResourceTransaction;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TransactionNotificationsTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testTransactionNotifications() throws Exception {
        final CountDownLatch latch = new CountDownLatch(3);
        DummyTransaction transaction = new DummyTransaction(muleContext);
        muleContext.registerListener((ServerNotificationListener)new TransactionNotificationListener<TransactionNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(TransactionNotification notification) {
                if (notification.getAction() == 1201) {
                    Assert.assertEquals((Object)"begin", (Object)notification.getActionName());
                    latch.countDown();
                } else if (notification.getAction() == 1202) {
                    Assert.assertEquals((Object)"commit", (Object)notification.getActionName());
                    latch.countDown();
                } else if (notification.getAction() == 1203) {
                    Assert.assertEquals((Object)"rollback", (Object)notification.getActionName());
                    latch.countDown();
                }
            }
        }, transaction.getId());
        transaction.begin();
        transaction.commit();
        transaction.rollback();
        latch.await(2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"There are still some notifications left unfired.", (long)0L, (long)latch.getCount());
    }

    private class DummyTransaction
    extends AbstractSingleResourceTransaction {
        private DummyTransaction(MuleContext muleContext) {
            super(muleContext);
        }

        protected Class getResourceType() {
            return null;
        }

        protected Class getKeyType() {
            return null;
        }

        protected void doBegin() throws TransactionException {
        }

        protected void doCommit() throws TransactionException {
        }

        protected void doRollback() throws TransactionException {
        }
    }
}

