/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction;

import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.transaction.TransactionCoordination;

public class TransactionTemplateTestUtils {
    public static ExecutionCallback getEmptyTransactionCallback(final Event returnObject) {
        return new ExecutionCallback<Event>(){

            public Event process() throws Exception {
                return returnObject;
            }
        };
    }

    public static ExecutionCallback<Event> getRollbackTransactionCallback(final Event returnObject) {
        return new ExecutionCallback(){

            public Event process() throws Exception {
                TransactionCoordination.getInstance().getTransaction().setRollbackOnly();
                return returnObject;
            }
        };
    }

    public static ExecutionCallback<Event> getFailureTransactionCallback() throws Exception {
        return new ExecutionCallback<Event>(){

            public Event process() throws Exception {
                throw (MessagingException)((Object)Mockito.mock(MessagingException.class, (Answer)Answers.RETURNS_MOCKS.get()));
            }
        };
    }

    public static ExecutionCallback<Event> getFailureTransactionCallback(final MessagingException mockMessagingException) throws Exception {
        return new ExecutionCallback<Event>(){

            public Event process() throws Exception {
                throw mockMessagingException;
            }
        };
    }

    public static ExecutionCallback<Event> getFailureTransactionCallbackStartsTransaction(final MessagingException mockMessagingException, final Transaction mockTransaction) {
        return new ExecutionCallback<Event>(){

            public Event process() throws Exception {
                TransactionCoordination.getInstance().bindTransaction(mockTransaction);
                throw mockMessagingException;
            }
        };
    }
}

