/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.transformer.CompositeConverter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CompositeConverterTestCase
extends AbstractMuleTestCase {
    private Converter mockConverterA = (Converter)Mockito.mock(Converter.class);
    private Converter mockConverterB = (Converter)Mockito.mock(Converter.class);

    @Test(expected=IllegalArgumentException.class)
    public void rejectsEmptyCompositeTransformer() throws Exception {
        new CompositeConverter(new Converter[0]);
    }

    @Test
    public void isSourceDataTypeSupported() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.isSourceDataTypeSupported(DataType.STRING)).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertTrue((boolean)chain.isSourceDataTypeSupported(DataType.STRING));
    }

    @Test
    public void getSourceDataTypes() {
        DataType[] dataTypes = new DataType[]{DataType.STRING};
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.getSourceDataTypes()).thenReturn(Arrays.asList(dataTypes));
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertEquals((Object)DataType.STRING, chain.getSourceDataTypes().get(0));
    }

    @Test
    public void isAcceptNull() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.isAcceptNull()).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertTrue((boolean)chain.isAcceptNull());
    }

    @Test
    public void isIgnoreBadInput() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.isIgnoreBadInput()).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertTrue((boolean)chain.isIgnoreBadInput());
    }

    @Test
    public void setReturnDataType() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        chain.setReturnDataType(DataType.STRING);
        ((Converter)Mockito.verify((Object)converter, (VerificationMode)Mockito.atLeastOnce())).setReturnDataType(DataType.STRING);
    }

    @Test
    public void getReturnDataType() {
        ((Converter)Mockito.doReturn((Object)DataType.STRING).when((Object)this.mockConverterB)).getReturnDataType();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((Object)DataType.STRING, (Object)compositeConverter.getReturnDataType());
    }

    @Test
    public void priorityWeighting() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Mockito.when((Object)this.mockConverterA.getPriorityWeighting()).thenReturn((Object)1);
        Mockito.when((Object)this.mockConverterB.getPriorityWeighting()).thenReturn((Object)2);
        int priorityWeighting = compositeConverter.getPriorityWeighting();
        Assert.assertEquals((int)3, (int)priorityWeighting);
    }

    @Test
    public void initialise() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        compositeConverter.initialise();
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).initialise();
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).initialise();
    }

    @Test
    public void dispose() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        compositeConverter.dispose();
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).dispose();
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).dispose();
    }

    @Test
    public void setMuleContext() {
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        compositeConverter.setMuleContext(mockMuleContext);
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).setMuleContext(mockMuleContext);
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).setMuleContext(mockMuleContext);
    }

    @Test
    public void transform() throws Exception {
        ((Converter)Mockito.doReturn((Object)"MyOutput1").when((Object)this.mockConverterA)).transform(Matchers.any());
        ((Converter)Mockito.doReturn((Object)DataType.builder().charset(StandardCharsets.UTF_8).build()).when((Object)this.mockConverterA)).getReturnDataType();
        ((Converter)Mockito.doReturn((Object)"MyOutput2").when((Object)this.mockConverterB)).transform(Matchers.eq((Object)"MyOutput1"), (Charset)Matchers.eq((Object)StandardCharsets.UTF_8));
        ((Converter)Mockito.doReturn((Object)DataType.builder().charset(StandardCharsets.UTF_8).build()).when((Object)this.mockConverterB)).getReturnDataType();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Object output = compositeConverter.transform((Object)"MyInput");
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.times((int)1))).transform((Object)"MyInput");
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.times((int)1))).transform((Object)"MyOutput1", StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"MyOutput2", (Object)output);
    }

    @Test
    public void appliesTransformerChainOnMessage() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        compositeConverter.setMuleContext(muleContext);
        Event event = this.testEvent();
        TransformationService transformationService = (TransformationService)Mockito.mock(TransformationService.class);
        ((TransformationService)Mockito.doReturn((Object)Mockito.mock(Message.class)).when((Object)transformationService)).applyTransformers((Message)Matchers.any(), (Event)Matchers.eq((Object)event), new Transformer[]{(Transformer)Matchers.eq((Object)compositeConverter)});
        ((MuleContext)Mockito.doReturn((Object)transformationService).when((Object)muleContext)).getTransformationService();
        compositeConverter.process(event);
        ((TransformationService)Mockito.verify((Object)transformationService, (VerificationMode)Mockito.times((int)1))).applyTransformers((Message)Matchers.eq((Object)this.testEvent().getMessage()), (Event)Matchers.eq((Object)this.testEvent()), new Transformer[]{(Transformer)Matchers.eq((Object)compositeConverter)});
    }
}

