/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.simple.StringToEnum;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StringToEnumTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private StringToEnum transformer = new StringToEnum(TestEnum.class);

    @Test
    public void transform() throws Exception {
        for (TestEnum value : TestEnum.values()) {
            Assert.assertThat((Object)this.transformer.transform((Object)value.name()), (Matcher)CoreMatchers.is((Object)((Object)value)));
        }
    }

    @Test
    public void illegalValue() throws Exception {
        this.expectedException.expect(TransformerException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.transformer.transform((Object)"NOT ENUM VALUE");
    }

    @Test
    public void nullClass() {
        this.expectedException.expect(IllegalArgumentException.class);
        new StringToEnum(null);
    }

    static enum TestEnum {
        A,
        B;

    }
}

