/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer;

import java.nio.charset.Charset;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.transformer.TransformerChain;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TransformerChainingTestCase
extends AbstractMuleContextTestCase {
    private TransformationService transformationService;

    @Before
    public void setUp() throws Exception {
        this.transformationService = new TransformationService(muleContext);
    }

    @Test
    public void testSingleChainedTransformer() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        Message message = Message.of((Object)new Integer(0));
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer});
        message = this.transformationService.applyTransformers(message, TransformerChainingTestCase.eventBuilder().message(Message.of((Object)0)).build(), new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload().getValue();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(1), (Object)transformedMessage);
    }

    @Test
    public void testTwoChainedTransformers() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        Message message = Message.of((Object)new Integer(0));
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, validTransformer});
        message = this.transformationService.applyTransformers(message, TransformerChainingTestCase.eventBuilder().message(Message.of((Object)0)).build(), Collections.singletonList(messageTransformer));
        Object transformedMessage = message.getPayload().getValue();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(2), (Object)transformedMessage);
    }

    @Test
    public void testThreeChainedTransformers() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        Message message = Message.of((Object)new Integer(0));
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, validTransformer, validTransformer});
        message = this.transformationService.applyTransformers(message, TransformerChainingTestCase.eventBuilder().message(Message.of((Object)0)).build(), new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload().getValue();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(3), (Object)transformedMessage);
    }

    @Test(expected=MessageTransformerException.class)
    public void testIgnoreBadInputBreaksWithTransformationOrderInvalidValidWhenEnforcedOn() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        Assert.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(true);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        Message message = Message.of((Object)new Integer(0));
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{invalidTransformer, validTransformer});
        this.transformationService.applyTransformers(message, TransformerChainingTestCase.eventBuilder().message(Message.of((Object)0)).build(), new Transformer[]{messageTransformer});
    }

    @Test
    public void testIgnoreBadInputBreaksChainWithTransformationOrderInvalidValid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        Assert.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(false);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        Message message = Message.of((Object)new Integer(0));
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{invalidTransformer, validTransformer});
        try {
            this.transformationService.applyTransformers(message, TransformerChainingTestCase.eventBuilder().message(Message.of((Object)0)).build(), new Transformer[]{messageTransformer});
            Assert.fail((String)"Transformer chain is expected to fail because of invalid transformer within chain.");
        }
        catch (MuleException muleException) {
            // empty catch block
        }
    }

    @Test
    public void testIgnoreBadInputBreaksChainWithTransformationOrderValidInvalid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        Assert.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(false);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        Message message = Message.of((Object)new Integer(0));
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, invalidTransformer});
        try {
            this.transformationService.applyTransformers(message, TransformerChainingTestCase.eventBuilder().message(Message.of((Object)0)).build(), new Transformer[]{messageTransformer});
            Assert.fail((String)"Transformer chain is expected to fail because of invalid transformer within chain.");
        }
        catch (MuleException tfe) {
            Assert.assertNotNull((Object)((Object)tfe));
        }
    }

    private Transformer getInvalidTransformer() throws Exception {
        AbstractTransformer transformer = new AbstractTransformer(){

            protected Object doTransform(Object src, Charset encoding) throws TransformerException {
                throw new RuntimeException("This transformer must not perform any transformations.");
            }
        };
        transformer.registerSourceType(DataType.fromType(((Object)((Object)this)).getClass()));
        return transformer;
    }

    private Transformer getIncreaseByOneTransformer() throws Exception {
        AbstractTransformer transformer = new AbstractTransformer(){

            protected Object doTransform(Object src, Charset encoding) throws TransformerException {
                return new Integer((Integer)src + 1);
            }
        };
        DataType integerDataType = DataType.fromType(Integer.class);
        transformer.registerSourceType(integerDataType);
        transformer.setReturnDataType(DataType.builder((DataType)integerDataType).charset(SystemUtils.getDefaultEncoding((MuleContext)muleContext)).build());
        return transformer;
    }
}

