/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.builder;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;

public abstract class AbstractMockTransformerBuilder<T extends AbstractMockTransformerBuilder> {
    protected String name;
    protected DataType resultDataType;
    protected DataType[] sourceDataTypes;
    protected Object value;

    public T named(String name) {
        this.name = name;
        return this.getThis();
    }

    public T from(DataType ... sourceDataTypes) {
        this.sourceDataTypes = sourceDataTypes;
        return this.getThis();
    }

    public T to(DataType resultDataType) {
        this.resultDataType = resultDataType;
        return this.getThis();
    }

    public T returning(Object value) {
        this.value = value;
        return this.getThis();
    }

    public Transformer build() {
        Transformer transformer;
        if (this.name == null || this.name.isEmpty()) {
            transformer = (Transformer)Mockito.mock(this.getClassToMock());
        } else {
            transformer = (Transformer)Mockito.mock(this.getClassToMock(), (String)this.name);
            ((Transformer)Mockito.doReturn((Object)this.name).when((Object)transformer)).getName();
        }
        if (this.resultDataType != null) {
            ((Transformer)Mockito.doReturn((Object)this.resultDataType).when((Object)transformer)).getReturnDataType();
        }
        if (this.sourceDataTypes != null) {
            ((Transformer)Mockito.doReturn(Arrays.asList(this.sourceDataTypes)).when((Object)transformer)).getSourceDataTypes();
            Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)Matchers.argThat((Matcher)new SupportsSourceDataType()))).thenReturn((Object)true);
        }
        try {
            ((Transformer)Mockito.doReturn((Object)this.value).when((Object)transformer)).transform(Mockito.any(Object.class));
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return transformer;
    }

    protected Class<? extends Transformer> getClassToMock() {
        return Transformer.class;
    }

    protected T getThis() {
        return (T)this;
    }

    class SupportsSourceDataType
    extends ArgumentMatcher {
        SupportsSourceDataType() {
        }

        public boolean matches(Object value) {
            DataType dataType = (DataType)value;
            for (DataType sourceDataType : AbstractMockTransformerBuilder.this.sourceDataTypes) {
                if (!sourceDataType.isCompatibleWith(dataType)) continue;
                return true;
            }
            return false;
        }
    }
}

