/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.compression;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.compression.GZipCompression;
import org.mule.runtime.core.internal.transformer.compression.GZipCompressTransformer;
import org.mule.runtime.core.internal.transformer.compression.GZipUncompressTransformer;
import org.mule.tck.core.transformer.AbstractTransformerTestCase;

public class GZipTransformerTestCase
extends AbstractTransformerTestCase {
    protected static final String TEST_DATA = "the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog";
    protected GZipCompression strat;

    protected void doSetUp() throws Exception {
        this.strat = new GZipCompression();
    }

    public Object getResultData() {
        try {
            return this.strat.compressByteArray(TEST_DATA.getBytes());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public Object getTestData() {
        return TEST_DATA;
    }

    public Transformer getTransformer() {
        GZipCompressTransformer transformer = new GZipCompressTransformer();
        transformer.setMuleContext(muleContext);
        return transformer;
    }

    public Transformer getRoundTripTransformer() {
        GZipUncompressTransformer transformer = new GZipUncompressTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnDataType(DataType.STRING);
        try {
            transformer.initialise();
        }
        catch (InitialisationException e) {
            Assert.fail((String)e.getMessage());
        }
        return transformer;
    }

    @Test
    public void testCompressAndDecompress() throws Exception {
        Transformer compressorTransformer = this.getTransformer();
        Transformer decompressorTransformer = this.getRoundTripTransformer();
        Object compressedData = compressorTransformer.transform(this.getTestData());
        Object decompressedData = decompressorTransformer.transform(compressedData);
        Assert.assertTrue((String)String.format("Compress and decompress process failed. Expected '%s', but got '%s'", this.getTestData(), decompressedData), (boolean)this.compareResults(this.getTestData(), decompressedData));
    }
}

