/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.datatype;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.datatype.StringToCharsetTransformer;
import org.mule.runtime.core.internal.transformer.datatype.StringToMediaTypeTransformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DataTypeTransformersTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void validCharset() throws TransformerException {
        StringToCharsetTransformer transformer = new StringToCharsetTransformer();
        Assert.assertThat((Object)transformer.transform((Object)StandardCharsets.US_ASCII.name()), (Matcher)CoreMatchers.is((Object)StandardCharsets.US_ASCII));
    }

    @Test
    public void invalidCharset() throws TransformerException {
        StringToCharsetTransformer transformer = new StringToCharsetTransformer();
        this.expected.expect(TransformerException.class);
        this.expected.expectCause(CoreMatchers.instanceOf(UnsupportedCharsetException.class));
        transformer.transform((Object)"invalid");
    }

    @Test
    public void validMediaType() throws TransformerException {
        StringToMediaTypeTransformer transformer = new StringToMediaTypeTransformer();
        MediaType transformed = (MediaType)transformer.transform((Object)"text/plain");
        Assert.assertThat((Object)transformed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)transformed.getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat((Object)transformed.getCharset().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void validMediaTypeWithCharset() throws TransformerException {
        StringToMediaTypeTransformer transformer = new StringToMediaTypeTransformer();
        MediaType transformed = (MediaType)transformer.transform((Object)("text/plain;charset=" + StandardCharsets.US_ASCII.name()));
        Assert.assertThat((Object)transformed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)transformed.getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat(transformed.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.US_ASCII));
    }

    @Test
    public void invalidMediaType() throws TransformerException {
        StringToMediaTypeTransformer transformer = new StringToMediaTypeTransformer();
        this.expected.expect(TransformerException.class);
        this.expected.expectCause(CoreMatchers.instanceOf(IllegalArgumentException.class));
        transformer.transform((Object)"invalid");
    }
}

