/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.registry.ResolverException;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.transformer.graph.CompositeConverterFilter;
import org.mule.runtime.core.transformer.graph.ConverterFilter;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CompositeConverterFilterTestCase {
    private static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    private static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");

    @Test
    public void filtersEmptyList() throws ResolverException {
        List transformers = Collections.emptyList();
        ConverterFilter filter1 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        ConverterFilter filter2 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        CompositeConverterFilter compositeConverterFilter = new CompositeConverterFilter(new ConverterFilter[]{filter1, filter2});
        List filteredTransformers = compositeConverterFilter.filter(transformers, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals(transformers, (Object)filteredTransformers);
        ((ConverterFilter)Mockito.verify((Object)filter1, (VerificationMode)Mockito.times((int)0))).filter((List)Matchers.any(List.class), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class));
        ((ConverterFilter)Mockito.verify((Object)filter2, (VerificationMode)Mockito.times((int)0))).filter((List)Matchers.any(List.class), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class));
    }

    @Test
    public void filtersSingletonList() throws Exception {
        Converter transformer1 = (Converter)Mockito.mock(Converter.class);
        List<Converter> transformers = Collections.singletonList(transformer1);
        ConverterFilter filter1 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        ConverterFilter filter2 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        CompositeConverterFilter compositeConverterFilter = new CompositeConverterFilter(new ConverterFilter[]{filter1, filter2});
        List filteredTransformers = compositeConverterFilter.filter(transformers, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals(transformers, (Object)filteredTransformers);
        ((ConverterFilter)Mockito.verify((Object)filter1, (VerificationMode)Mockito.times((int)0))).filter((List)Matchers.any(List.class), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class));
        ((ConverterFilter)Mockito.verify((Object)filter2, (VerificationMode)Mockito.times((int)0))).filter((List)Matchers.any(List.class), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class));
    }

    @Test
    public void stopsFilteringWhenGetsOneResult() throws Exception {
        Converter transformer1 = (Converter)Mockito.mock(Converter.class);
        Converter transformer2 = (Converter)Mockito.mock(Converter.class);
        ArrayList<Converter> transformers = new ArrayList<Converter>();
        transformers.add(transformer1);
        transformers.add(transformer2);
        ConverterFilter filter1 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        List<Converter> expectedFilteredTransformers = Collections.singletonList(transformer1);
        Mockito.when((Object)filter1.filter(transformers, XML_DATA_TYPE, JSON_DATA_TYPE)).thenReturn(expectedFilteredTransformers);
        ConverterFilter filter2 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        CompositeConverterFilter compositeConverterFilter = new CompositeConverterFilter(new ConverterFilter[]{filter1, filter2});
        List filteredTransformers = compositeConverterFilter.filter(transformers, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals(expectedFilteredTransformers, (Object)filteredTransformers);
        ((ConverterFilter)Mockito.verify((Object)filter2, (VerificationMode)Mockito.times((int)0))).filter((List)Matchers.any(List.class), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class));
    }

    @Test
    public void failsWhenFiltersDoNotReduceListToASingleElement() throws Exception {
        Converter transformer1 = (Converter)Mockito.mock(Converter.class);
        Converter transformer2 = (Converter)Mockito.mock(Converter.class);
        ArrayList<Converter> transformers = new ArrayList<Converter>();
        transformers.add(transformer1);
        transformers.add(transformer2);
        ConverterFilter filter1 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        Mockito.when((Object)filter1.filter(transformers, XML_DATA_TYPE, JSON_DATA_TYPE)).thenReturn(transformers);
        ConverterFilter filter2 = (ConverterFilter)Mockito.mock(ConverterFilter.class);
        Mockito.when((Object)filter2.filter(transformers, XML_DATA_TYPE, JSON_DATA_TYPE)).thenReturn(transformers);
        CompositeConverterFilter compositeConverterFilter = new CompositeConverterFilter(new ConverterFilter[]{filter1, filter2});
        List filteredTransformers = compositeConverterFilter.filter(transformers, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals(transformers, (Object)filteredTransformers);
        ((ConverterFilter)Mockito.verify((Object)filter1, (VerificationMode)Mockito.times((int)1))).filter((List)Matchers.any(List.class), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class));
        ((ConverterFilter)Mockito.verify((Object)filter2, (VerificationMode)Mockito.times((int)1))).filter((List)Matchers.any(List.class), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class));
    }
}

