/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.graph;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.registry.ResolverException;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.transformer.graph.PriorityWeightingConverterFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PriorityWeightingConverterFilterTestCase
extends AbstractMuleTestCase {
    private static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    private static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");
    private static final DataType INPUT_STREAM_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"INPUT_STREAM_DATA_TYPE");
    private static final DataType STRING_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"STRING_DATA_TYPE");
    private PriorityWeightingConverterFilter filter = new PriorityWeightingConverterFilter();

    @BeforeClass
    public static void setupDataTypes() {
        ((DataType)Mockito.doReturn((Object)true).when((Object)XML_DATA_TYPE)).isCompatibleWith(XML_DATA_TYPE);
        ((DataType)Mockito.doReturn(XML_CLASS.class).when((Object)XML_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)JSON_DATA_TYPE)).isCompatibleWith(JSON_DATA_TYPE);
        ((DataType)Mockito.doReturn(JSON_CLASS.class).when((Object)JSON_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)INPUT_STREAM_DATA_TYPE)).isCompatibleWith(INPUT_STREAM_DATA_TYPE);
        ((DataType)Mockito.doReturn(INPUT_STREAM_CLASS.class).when((Object)INPUT_STREAM_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)STRING_DATA_TYPE)).isCompatibleWith(STRING_DATA_TYPE);
        ((DataType)Mockito.doReturn(STRING_CLASS.class).when((Object)STRING_DATA_TYPE)).getType();
    }

    @Test
    public void filtersEmptyList() throws ResolverException {
        ArrayList availableConverters = new ArrayList();
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void filtersSameWeight() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToInputStream);
        availableConverters.add(xmlToString);
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)2, (int)converters.size());
        Assert.assertTrue((boolean)converters.contains(xmlToInputStream));
        Assert.assertTrue((boolean)converters.contains(xmlToString));
    }

    @Test
    public void filtersSameLengthDifferentWeightsAddingBetterTransformerFirst() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(2)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToInputStream);
        availableConverters.add(xmlToString);
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)1, (int)converters.size());
        Assert.assertEquals((Object)xmlToInputStream, converters.get(0));
    }

    @Test
    public void filtersSameLengthDifferentWeightsAddingBetterTransformerLast() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(2)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(xmlToInputStream);
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)1, (int)converters.size());
        Assert.assertEquals((Object)xmlToInputStream, converters.get(0));
    }

    private static class STRING_CLASS {
        private STRING_CLASS() {
        }
    }

    private static class INPUT_STREAM_CLASS {
        private INPUT_STREAM_CLASS() {
        }
    }

    private static class JSON_CLASS {
        private JSON_CLASS() {
        }
    }

    private static class XML_CLASS {
        private XML_CLASS() {
        }
    }
}

