/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.graph;

import java.util.List;
import org.jgrapht.DirectedGraph;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.transformer.CompositeConverter;
import org.mule.runtime.core.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.transformer.graph.TransformationGraph;
import org.mule.runtime.core.transformer.graph.TransformationGraphLookupStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TransformationGraphLookupStrategyTestCase
extends AbstractMuleTestCase {
    private static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    private static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");
    private static final DataType INPUT_STREAM_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"INPUT_STREAM_DATA_TYPE");
    private static final DataType STRING_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"STRING_DATA_TYPE");
    private TransformationGraph graph = new TransformationGraph();
    private TransformationGraphLookupStrategy lookupStrategyTransformation = new TransformationGraphLookupStrategy((DirectedGraph)this.graph);

    @Test
    public void lookupTransformersNoSourceInGraph() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(JSON_DATA_TYPE, INPUT_STREAM_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void lookupTransformersNoTargetInGraph() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void findsDirectTransformation() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)converters.size());
        junit.framework.Assert.assertEquals((Object)inputStreamToXml, converters.get(0));
    }

    @Test
    public void findsMultipleDirectTransformations() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        Converter betterInputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(betterInputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)2, (int)converters.size());
        Assert.assertTrue((boolean)converters.contains(inputStreamToXml));
        Assert.assertTrue((boolean)converters.contains(betterInputStreamToXml));
    }

    @Test
    public void findsCompositeConverter() throws Exception {
        Converter inputStreamToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToString")).from(INPUT_STREAM_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToString);
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        this.graph.addConverter(stringToJson);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)converters.size());
        this.assertContainsCompositeTransformer(converters, inputStreamToString, stringToJson);
    }

    @Test
    public void findsMultipleCompositeConvertersWithMultipleEdgesFromSource() throws Exception {
        Converter inputStreamToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToString")).from(INPUT_STREAM_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToString);
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToJson);
        Converter jsonToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("jsonToXml")).from(JSON_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(jsonToXml);
        Converter jsonToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("jsonToString")).from(JSON_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graph.addConverter(jsonToString);
        Converter stringToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToXml")).from(STRING_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(stringToXml);
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        this.graph.addConverter(stringToJson);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)4, (int)converters.size());
        this.assertContainsCompositeTransformer(converters, inputStreamToString, stringToXml);
        this.assertContainsCompositeTransformer(converters, inputStreamToJson, jsonToXml);
        this.assertContainsCompositeTransformer(converters, inputStreamToString, stringToJson, jsonToXml);
    }

    private void assertContainsCompositeTransformer(List<Converter> converters, Converter ... composedConverters) {
        for (Converter converter : converters) {
            CompositeConverter compositeConverter;
            if (!(converter instanceof CompositeConverter) || (compositeConverter = (CompositeConverter)converter).getConverters().size() != composedConverters.length) continue;
            boolean matches = true;
            for (int i = 0; i < composedConverters.length - 1; ++i) {
                if (composedConverters[i] == compositeConverter.getConverters().get(i)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return;
        }
        junit.framework.Assert.fail((String)("Converter list does not contain a composite converter with: " + composedConverters));
    }
}

