/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class BasicTypeAutoTransformationTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testTypes() throws TransformerException {
        this.testType("1", Integer.class, Integer.TYPE, 1);
        this.testType("1", Long.class, Long.TYPE, 1L);
        this.testType("1", Short.class, Short.TYPE, (short)1);
        this.testType("1.1", Double.class, Double.TYPE, 1.1);
        this.testType("1.1", Float.class, Float.TYPE, Float.valueOf(1.1f));
        this.testType("1.1", BigDecimal.class, null, BigDecimal.valueOf(1.1));
        this.testType("true", Boolean.class, Boolean.TYPE, Boolean.TRUE);
    }

    protected void testType(String string, Class type, Class primitive, Object value) throws TransformerException {
        Assert.assertEquals((Object)value, (Object)this.lookupFromStringTransformer(type).transform((Object)string));
        Assert.assertEquals((Object)string, (Object)this.lookupToStringTransformer(type).transform(value));
        if (primitive != null) {
            Assert.assertEquals((Object)value, (Object)this.lookupFromStringTransformer(primitive).transform((Object)string));
            Assert.assertEquals((Object)string, (Object)this.lookupToStringTransformer(primitive).transform(value));
        }
    }

    private Transformer lookupFromStringTransformer(Class to) throws TransformerException {
        return muleContext.getRegistry().lookupTransformer(DataType.STRING, DataType.fromType((Class)to));
    }

    private Transformer lookupToStringTransformer(Class from) throws TransformerException {
        return muleContext.getRegistry().lookupTransformer(DataType.fromType((Class)from), DataType.STRING);
    }
}

