/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.transformer.simple.CopyPropertiesProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class CopyPropertiesProcessorTestCase
extends AbstractMuleTestCase {
    public static final Charset ENCODING = StandardCharsets.US_ASCII;
    public static final String INBOUND_PROPERTY_KEY = "propKey";
    public static final DataType PROPERTY_DATA_TYPE = DataType.STRING;
    private static final Serializable PROPERTY_VALUE = "propValue";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    private Message muleMessage;
    @Mock
    private ExtendedExpressionManager mockExpressionManager;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        this.muleMessage = Message.builder().payload((Object)"").mediaType(PROPERTY_DATA_TYPE.getMediaType()).build();
    }

    @Test
    public void testCopySingleProperty() throws MuleException {
        CopyPropertiesProcessor copyPropertiesTransformer = this.createCopyPropertiesTransformer(INBOUND_PROPERTY_KEY);
        this.muleMessage = InternalMessage.builder((Message)this.muleMessage).addInboundProperty(INBOUND_PROPERTY_KEY, PROPERTY_VALUE, PROPERTY_DATA_TYPE).build();
        Event muleEvent = MuleContextUtils.eventBuilder().message(this.muleMessage).build();
        InternalMessage transformed = (InternalMessage)copyPropertiesTransformer.process(muleEvent).getMessage();
        Assert.assertThat((Object)transformed.getOutboundProperty(INBOUND_PROPERTY_KEY), (Matcher)CoreMatchers.is((Object)PROPERTY_VALUE));
        Assert.assertThat((Object)transformed.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void testCopyNonExistentProperty() throws MuleException {
        CopyPropertiesProcessor copyPropertiesTransformer = this.createCopyPropertiesTransformer(INBOUND_PROPERTY_KEY);
        Event muleEvent = MuleContextUtils.eventBuilder().message(this.muleMessage).build();
        InternalMessage transformed = (InternalMessage)copyPropertiesTransformer.process(muleEvent).getMessage();
        Assert.assertThat((Object)transformed.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testCopyUsingRegex() throws MuleException {
        CopyPropertiesProcessor copyPropertiesTransformer = this.createCopyPropertiesTransformer("MULE_*");
        this.muleMessage = InternalMessage.builder((Message)this.muleMessage).addInboundProperty("MULE_ID", PROPERTY_VALUE, PROPERTY_DATA_TYPE).addInboundProperty("MULE_GROUP_ID", PROPERTY_VALUE, PROPERTY_DATA_TYPE).addInboundProperty("SomeVar", PROPERTY_VALUE, PROPERTY_DATA_TYPE).build();
        Event muleEvent = MuleContextUtils.eventBuilder().message(this.muleMessage).build();
        InternalMessage transformed = (InternalMessage)copyPropertiesTransformer.process(muleEvent).getMessage();
        Assert.assertThat((Object)transformed.getOutboundProperty("SomeVar"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)transformed.getOutboundProperty("MULE_ID"), (Matcher)CoreMatchers.is((Object)PROPERTY_VALUE));
        Assert.assertThat((Object)transformed.getOutboundProperty("MULE_GROUP_ID"), (Matcher)CoreMatchers.is((Object)PROPERTY_VALUE));
    }

    public CopyPropertiesProcessor createCopyPropertiesTransformer(String inboundPropertyKey) throws InitialisationException {
        CopyPropertiesProcessor copyPropertiesTransformer = new CopyPropertiesProcessor();
        copyPropertiesTransformer.setMuleContext(this.mockMuleContext);
        copyPropertiesTransformer.setPropertyName(inboundPropertyKey);
        copyPropertiesTransformer.initialise();
        return copyPropertiesTransformer;
    }
}

