/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.simple.ByteArrayToHexString;
import org.mule.runtime.core.transformer.simple.HexStringToByteArray;
import org.mule.tck.core.transformer.AbstractTransformerTestCase;

public class HexStringByteArrayTransformersTestCase
extends AbstractTransformerTestCase {
    public Transformer getTransformer() {
        return new HexStringToByteArray();
    }

    public Transformer getRoundTripTransformer() {
        return new ByteArrayToHexString();
    }

    public Object getTestData() {
        return "01020aff";
    }

    public Object getResultData() {
        return new byte[]{1, 2, 10, -1};
    }

    public boolean compareResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        return Arrays.equals((byte[])src, (byte[])result);
    }

    public boolean compareRoundtripResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        return src.equals(result);
    }

    @Test
    public void testUppercase() throws TransformerException {
        ByteArrayToHexString t = new ByteArrayToHexString();
        t.setUpperCase(true);
        Assert.assertEquals((Object)((String)this.getTestData()).toUpperCase(), (Object)t.transform(this.getResultData()));
    }

    @Test
    public void testStreaming() throws TransformerException {
        ByteArrayToHexString transformer = new ByteArrayToHexString();
        ByteArrayInputStream input = new ByteArrayInputStream((byte[])this.getResultData());
        Assert.assertEquals((Object)this.getTestData(), (Object)transformer.transform((Object)input));
    }
}

