/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.transformer.simple.ParseTemplateTransformer;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ParseTemplateTransformerTestCase {
    private static final String LOCATION = "error.html";
    private static final String INVALID_LOCATION = "wrong_error.html";
    private ParseTemplateTransformer parseTemplateTransformer;
    private Event mockMuleEvent = (Event)Mockito.mock(Event.class);
    private InternalMessage mockMuleMessage = (InternalMessage)Mockito.mock(InternalMessage.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExtendedExpressionManager mockExpressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);

    @Before
    public void setUp() {
        this.parseTemplateTransformer = new ParseTemplateTransformer();
        this.parseTemplateTransformer.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.mockMuleMessage);
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseTemplateNullTemplate() throws TransformerException, InitialisationException {
        this.parseTemplateTransformer.setLocation(LOCATION);
        this.parseTemplateTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
    }

    @Test(expected=InitialisationException.class)
    public void testParseTemplateNullLocation() throws TransformerException, InitialisationException {
        this.parseTemplateTransformer.setLocation(null);
        this.parseTemplateTransformer.initialise();
        this.parseTemplateTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
    }

    @Test(expected=InitialisationException.class)
    public void testParseTemplateInvalidLocation() throws TransformerException, InitialisationException {
        this.parseTemplateTransformer.setLocation(INVALID_LOCATION);
        this.parseTemplateTransformer.initialise();
        this.parseTemplateTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
    }

    @Test
    public void testParseTemplate() throws TransformerException, InitialisationException, IOException {
        this.parseTemplateTransformer.setLocation(LOCATION);
        this.parseTemplateTransformer.initialise();
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("errorMessage")).thenReturn((Object)"ERROR!!!");
        String expectedExpression = IOUtils.getResourceAsString((String)LOCATION, this.getClass());
        Mockito.when((Object)this.mockExpressionManager.parse(expectedExpression, this.mockMuleEvent, null)).thenReturn((Object)"Parsed");
        Object response = this.parseTemplateTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Parsed", (Object)response);
        response = this.parseTemplateTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Parsed", (Object)response);
    }
}

