/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Ignore;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.transformer.simple.ByteArrayToMuleMessage;
import org.mule.runtime.core.transformer.simple.MuleMessageToByteArray;
import org.mule.tck.core.transformer.AbstractTransformerTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class SerializedMuleMessageTransformersTestCase
extends AbstractTransformerTestCase {
    private Message testObject = null;

    protected void doSetUp() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("object", new Apple());
        props.put("number", 1);
        props.put("string", "hello");
        this.testObject = InternalMessage.builder().payload((Object)"test").outboundProperties(props).build();
        Event.setCurrentEvent((Event)SerializedMuleMessageTransformersTestCase.eventBuilder().message(this.testObject).session((MuleSession)new DefaultMuleSession()).build());
    }

    protected void doTearDown() throws Exception {
        Event.setCurrentEvent(null);
    }

    public void testTransform() throws Exception {
    }

    public Transformer getTransformer() throws Exception {
        return (Transformer)this.createObject(MuleMessageToByteArray.class);
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return (Transformer)this.createObject(ByteArrayToMuleMessage.class);
    }

    public Object getTestData() {
        return this.testObject;
    }

    public Object getResultData() {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)bs);
            os.writeObject(this.testObject);
            os.flush();
            os.close();
            return bs.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean compareResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        return Arrays.equals((byte[])src, (byte[])result);
    }

    @Ignore(value="See MULE-6046")
    public void testRoundTrip() throws Exception {
    }

    public boolean compareRoundtripResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        if (src instanceof InternalMessage && result instanceof InternalMessage) {
            InternalMessage sourceMuleMessage = (InternalMessage)src;
            InternalMessage resultMuleMessage = (InternalMessage)result;
            boolean payloadsAreEqual = this.comparePayloads(sourceMuleMessage, resultMuleMessage);
            boolean objectPropertiesAreEqual = this.compareObjectProperties(sourceMuleMessage, resultMuleMessage);
            boolean stringPropertiesAreEqual = this.compareStringProperties(sourceMuleMessage, resultMuleMessage);
            boolean intPropertiesAreEqual = this.compareIntProperties(sourceMuleMessage, resultMuleMessage);
            return payloadsAreEqual && objectPropertiesAreEqual && stringPropertiesAreEqual && intPropertiesAreEqual;
        }
        return false;
    }

    private boolean comparePayloads(InternalMessage src, InternalMessage result) {
        Object sourcePayload = src.getPayload().getValue();
        Object resultPayload = result.getPayload().getValue();
        return sourcePayload.equals(resultPayload);
    }

    private boolean compareObjectProperties(InternalMessage src, InternalMessage result) {
        Serializable sourceObjectProperty = src.getOutboundProperty("object");
        Serializable resultObjectProperty = result.getOutboundProperty("object");
        return sourceObjectProperty.equals(resultObjectProperty);
    }

    private boolean compareStringProperties(InternalMessage src, InternalMessage result) {
        Serializable sourceStringProperty = src.getOutboundProperty("string");
        Serializable resultStringProperty = result.getOutboundProperty("string");
        return sourceStringProperty.equals(resultStringProperty);
    }

    private boolean compareIntProperties(InternalMessage src, InternalMessage result) {
        int resultIntProperty;
        int sourceIntProperty = (Integer)src.getOutboundProperty("number", (Serializable)Integer.valueOf(-1));
        return sourceIntProperty == (resultIntProperty = ((Integer)result.getOutboundProperty("number", (Serializable)Integer.valueOf(-2))).intValue());
    }
}

