/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.transformer.simple.SetPayloadTransformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SetPayloadTransformerTestCase
extends AbstractMuleTestCase {
    private static final String PLAIN_TEXT = "This is a plain text";
    private static final String EXPRESSION = "#[mel:testVariable]";
    private SetPayloadTransformer setPayloadTransformer;
    private MuleContext mockMuleContext;
    private Event mockMuleEvent;
    private InternalMessage mockMuleMessage;
    private ExtendedExpressionManager mockExpressionManager;

    @Before
    public void setUp() {
        this.setPayloadTransformer = new SetPayloadTransformer();
        this.mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.setPayloadTransformer.setMuleContext(this.mockMuleContext);
        this.mockExpressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        this.mockMuleEvent = (Event)Mockito.mock(Event.class);
        this.mockMuleMessage = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.mockMuleMessage);
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenAnswer(invocation -> (String)invocation.getArguments()[0]);
    }

    @Test
    public void testSetPayloadTransformerNulValue() throws InitialisationException, TransformerException {
        this.setPayloadTransformer.setValue(null);
        this.setPayloadTransformer.initialise();
        Object response = this.setPayloadTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testSetPayloadTransformerPlainText() throws InitialisationException, TransformerException {
        this.setPayloadTransformer.setValue(PLAIN_TEXT);
        this.setPayloadTransformer.initialise();
        Mockito.when((Object)this.mockExpressionManager.isExpression(PLAIN_TEXT)).thenReturn((Object)false);
        Object response = this.setPayloadTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
        Assert.assertEquals((Object)PLAIN_TEXT, (Object)response);
    }

    @Test
    public void testSetPayloadTransformerExpression() throws InitialisationException, TransformerException {
        this.setPayloadTransformer.setValue(EXPRESSION);
        Mockito.when((Object)this.mockExpressionManager.isExpression(EXPRESSION)).thenReturn((Object)true);
        this.setPayloadTransformer.initialise();
        TypedValue typedValue = new TypedValue((Object)PLAIN_TEXT, DataType.STRING);
        Mockito.when((Object)this.mockExpressionManager.evaluate(EXPRESSION, this.mockMuleEvent)).thenReturn((Object)typedValue);
        Object response = this.setPayloadTransformer.transformMessage(this.mockMuleEvent, StandardCharsets.UTF_8);
        Assert.assertEquals((Object)PLAIN_TEXT, (Object)response);
    }
}

