/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.wire.WireFormat;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.transformer.simple.ObjectToString;
import org.mule.runtime.core.transformer.wire.TransformerPairWireFormat;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Orange;

public abstract class AbstractWireFormatTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testWriteReadMessage() throws Exception {
        HashMap<String, String> messageProerties = new HashMap<String, String>();
        messageProerties.put("key1", "val1");
        InternalMessage inMessage = InternalMessage.builder().payload((Object)"testMessage").outboundProperties(messageProerties).build();
        Object outMessage = this.readWrite(inMessage);
        Assert.assertTrue((boolean)(outMessage instanceof String));
        Assert.assertEquals((Object)"testMessage", (Object)outMessage);
    }

    @Test
    public void testWriteReadPayload() throws Exception {
        Properties messageProerties = new Properties();
        messageProerties.put("key1", "val1");
        Orange inOrange = new Orange();
        inOrange.setBrand("Walmart");
        inOrange.setMapProperties((Map)messageProerties);
        Object outObject = this.readWrite(inOrange);
        Assert.assertTrue((boolean)(outObject instanceof Orange));
        Assert.assertEquals((Object)"Walmart", (Object)((Orange)outObject).getBrand());
        Assert.assertEquals((Object)"val1", ((Orange)outObject).getMapProperties().get("key1"));
    }

    protected Object readWrite(Object inObject) throws Exception {
        WireFormat wireFormat = this.getWireFormat();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        wireFormat.write((OutputStream)out, inObject, StandardCharsets.UTF_8);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Object outMessage = wireFormat.read((InputStream)in);
        Assert.assertNotNull((Object)outMessage);
        return outMessage;
    }

    @Test
    public void testSetInboundTransformer() throws Exception {
        TransformerPairWireFormat transPairWireFormat = (TransformerPairWireFormat)this.getWireFormat();
        transPairWireFormat.setInboundTransformer((Transformer)new ObjectToString());
        Assert.assertTrue((boolean)(transPairWireFormat.getInboundTransformer() instanceof ObjectToString));
    }

    @Test
    public void testSetOutboundTransformer() throws Exception {
        TransformerPairWireFormat transPairWireFormat = (TransformerPairWireFormat)this.getWireFormat();
        transPairWireFormat.setInboundTransformer((Transformer)new ObjectToString());
        Assert.assertTrue((boolean)(transPairWireFormat.getInboundTransformer() instanceof ObjectToString));
    }

    @Test
    public abstract void testGetDefaultInboundTransformer() throws Exception;

    @Test
    public abstract void testGetDefaultOutboundTransformer() throws Exception;

    protected abstract WireFormat getWireFormat() throws Exception;
}

