/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.internal.util.ArrayUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ArrayUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testToArrayOfComponentType() {
        Assert.assertNull((Object)ArrayUtils.toArrayOfComponentType(null, String.class));
        Object[] a = new String[]{};
        String[] a2 = (String[])ArrayUtils.toArrayOfComponentType((Object[])a, String.class);
        Assert.assertSame((Object)a2, (Object)a);
        try {
            ArrayUtils.toArrayOfComponentType((Object[])a, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        a = new String[]{":-)"};
        CharSequence[] cs = (CharSequence[])ArrayUtils.toArrayOfComponentType((Object[])a, CharSequence.class);
        Assert.assertEquals((long)a.length, (long)cs.length);
        Assert.assertSame((Object)a[0], (Object)cs[0]);
        try {
            ArrayUtils.toArrayOfComponentType((Object[])a, List.class);
            Assert.fail();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testToStringMaxLength() {
        byte[] test = new byte[100];
        for (int i = 0; i < test.length; ++i) {
            test[i] = (byte)i;
        }
        String result = ArrayUtils.toString((Object)test, (int)10);
        Assert.assertTrue((boolean)result.endsWith("[..]}"));
        Assert.assertEquals((long)9L, (long)StringUtils.countMatches((String)result, (String)","));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLengthOfNonArray() {
        ArrayUtils.getLength((Object)new Object());
    }
}

