/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.AbstractFruit;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;

@SmallTest
public class ClassUtilsTestCase
extends AbstractMuleTestCase {
    protected final Set<String> ignoreMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler"));

    @Test
    public void testIsConcrete() throws Exception {
        Assert.assertTrue((boolean)ClassUtils.isConcrete(Orange.class));
        Assert.assertTrue((!ClassUtils.isConcrete(Fruit.class) ? 1 : 0) != 0);
        Assert.assertTrue((!ClassUtils.isConcrete(AbstractFruit.class) ? 1 : 0) != 0);
        try {
            ClassUtils.isConcrete(null);
            Assert.fail((String)"Class cannot be null, exception should be thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadClass() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.String", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)clazz);
        Assert.assertEquals((Object)clazz.getName(), (Object)"java.lang.String");
        try {
            ClassUtils.loadClass((String)"java.lang.Bing", ((Object)((Object)this)).getClass());
            Assert.fail((String)"ClassNotFoundException should be thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadPrimitiveClass() throws Exception {
        Assert.assertSame((Object)ClassUtils.loadClass((String)"boolean", ((Object)((Object)this)).getClass()), Boolean.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"byte", ((Object)((Object)this)).getClass()), Byte.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"char", ((Object)((Object)this)).getClass()), Character.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"double", ((Object)((Object)this)).getClass()), Double.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"float", ((Object)((Object)this)).getClass()), Float.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"int", ((Object)((Object)this)).getClass()), Integer.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"long", ((Object)((Object)this)).getClass()), Long.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"short", ((Object)((Object)this)).getClass()), Short.TYPE);
    }

    @Test
    public void testLoadClassOfType() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.IllegalArgumentException", ((Object)((Object)this)).getClass(), Exception.class);
        Assert.assertNotNull((Object)clazz);
        Assert.assertEquals((Object)clazz.getName(), (Object)"java.lang.IllegalArgumentException");
        try {
            ClassUtils.loadClass((String)"java.lang.UnsupportedOperationException", ((Object)((Object)this)).getClass(), String.class);
            Assert.fail((String)"IllegalArgumentException should be thrown since class is not of expected type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInstanciateClass() throws Exception {
        Object object = ClassUtils.instantiateClass((String)"org.mule.tck.testmodels.fruit.Orange", (Object[])new Object[0]);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Orange));
        object = ClassUtils.instantiateClass((String)"org.mule.tck.testmodels.fruit.FruitBowl", (Object[])new Object[]{new Apple(), new Banana()});
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof FruitBowl));
        FruitBowl bowl = (FruitBowl)object;
        Assert.assertTrue((boolean)bowl.hasApple());
        Assert.assertTrue((boolean)bowl.hasBanana());
        try {
            ClassUtils.instantiateClass((String)"java.lang.Bing", (Object[])new Object[0]);
            Assert.fail((String)"Class does not exist, ClassNotFoundException should have been thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetParameterTypes() throws Exception {
        FruitBowl bowl = new FruitBowl();
        Class[] classes = ClassUtils.getParameterTypes((Object)bowl, (String)"apple");
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)1L, (long)classes.length);
        Assert.assertEquals(Apple.class, (Object)classes[0]);
        classes = ClassUtils.getParameterTypes((Object)bowl, (String)"invalid");
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)0L, (long)classes.length);
    }

    @Test
    public void testLoadingResources() throws Exception {
        URL resource = ClassUtils.getResource((String)"log4j2-test.xml", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)resource);
        resource = ClassUtils.getResource((String)"does-not-exist.properties", ((Object)((Object)this)).getClass());
        Assert.assertNull((Object)resource);
    }

    @Test
    public void testLoadingResourceEnumeration() throws Exception {
        Enumeration enumeration = ClassUtils.getResources((String)"log4j2-test.xml", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)enumeration);
        Assert.assertTrue((boolean)enumeration.hasMoreElements());
        enumeration = ClassUtils.getResources((String)"does-not-exist.properties", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)enumeration);
        Assert.assertTrue((!enumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    @Test
    public void testGetSatisfiableMethods() throws Exception {
        List methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{Apple.class}, (boolean)true, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)2L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{Apple.class}, (boolean)false, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)0L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)true, (boolean)false, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)0L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)true, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)2L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)false, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)1L, (long)methods.size());
        Assert.assertEquals((Object)"doSomethingElse", (Object)((Method)methods.get(0)).getName());
        methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{WaterMelon[].class}, (boolean)true, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)1L, (long)methods.size());
        Assert.assertEquals((Object)"setFruit", (Object)((Method)methods.get(0)).getName());
    }

    @Test
    public void testSimpleName() {
        this.simpleNameHelper("String", "foo".getClass());
        this.simpleNameHelper("int[]", new int[0].getClass());
        this.simpleNameHelper("Object[][]", new Object[0][0].getClass());
        this.simpleNameHelper("null", null);
    }

    @Test
    public void testEqual() {
        HashBlob a1 = new HashBlob(1);
        HashBlob a2 = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        Assert.assertTrue((boolean)ClassUtils.equal((Object)a1, (Object)a2));
        Assert.assertTrue((boolean)ClassUtils.equal((Object)b, (Object)b));
        Assert.assertTrue((boolean)ClassUtils.equal(null, null));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)a1, (Object)b));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)a2, (Object)b));
        Assert.assertFalse((boolean)ClassUtils.equal(null, (Object)b));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)b, (Object)a1));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)b, (Object)a2));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)b, null));
    }

    @Test
    public void testHash() {
        HashBlob a = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        Assert.assertTrue((ClassUtils.hash((Object[])new Object[]{a, b, a, b}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        Assert.assertFalse((ClassUtils.hash((Object[])new Object[]{a, b, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        Assert.assertFalse((ClassUtils.hash((Object[])new Object[]{a, b, a, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        Assert.assertFalse((ClassUtils.hash((Object[])new Object[]{b, a, b, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
    }

    @Test
    public void testClassTypesWithNullInArray() {
        Object[] array = new Object[]{"hello", null, "world"};
        Class[] classTypes = ClassUtils.getClassTypes((Object)array);
        Assert.assertEquals((long)3L, (long)classTypes.length);
        Assert.assertEquals(String.class, (Object)classTypes[0]);
        Assert.assertEquals(null, (Object)classTypes[1]);
        Assert.assertEquals(String.class, (Object)classTypes[2]);
    }

    @Test
    public void testCompareWithNull() {
        Class[] c1 = new Class[]{String.class, Integer.class};
        Class[] c2 = new Class[]{String.class, null};
        Assert.assertFalse((boolean)ClassUtils.compare((Class[])c1, (Class[])c2, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.compare((Class[])c2, (Class[])c1, (boolean)true));
    }

    @Test
    public void getFieldValue() throws Exception {
        int hash = ((Object)((Object)this)).hashCode();
        HashBlob blob = new HashBlob(hash);
        Assert.assertThat((Object)hash, (Matcher)CoreMatchers.equalTo((Object)ClassUtils.getFieldValue((Object)blob, (String)"hash", (boolean)false)));
    }

    @Test(expected=NoSuchFieldException.class)
    public void getUnexistentFieldValue() throws Exception {
        ClassUtils.getFieldValue((Object)new HashBlob(0), (String)"fake", (boolean)false);
    }

    @Test
    public void getFieldValueRecursive() throws Exception {
        int hash = ((Object)((Object)this)).hashCode();
        ExtendedHashBlob blob = new ExtendedHashBlob(hash);
        Assert.assertThat((Object)hash, (Matcher)CoreMatchers.equalTo((Object)ClassUtils.getFieldValue((Object)blob, (String)"hash", (boolean)true)));
    }

    @Test(expected=NoSuchFieldException.class)
    public void getUnexistentFieldValueRecursive() throws Exception {
        ClassUtils.getFieldValue((Object)new ExtendedHashBlob(1), (String)"fake", (boolean)true);
    }

    @Test(expected=NoSuchFieldException.class)
    public void getInheritedFieldValueWithoutRecurse() throws Exception {
        ClassUtils.getFieldValue((Object)new ExtendedHashBlob(1), (String)"hash", (boolean)false);
    }

    @Test
    public void setFieldValue() throws Exception {
        HashBlob blob = new HashBlob(0);
        int hash = ((Object)((Object)this)).hashCode();
        ClassUtils.setFieldValue((Object)blob, (String)"hash", (Object)hash, (boolean)false);
        Assert.assertThat((Object)hash, (Matcher)CoreMatchers.equalTo((Object)blob.getHash()));
    }

    @Test(expected=NoSuchFieldException.class)
    public void setUnexistentFieldValue() throws Exception {
        ClassUtils.setFieldValue((Object)new HashBlob(0), (String)"fake", (Object)0, (boolean)false);
    }

    @Test
    public void setFieldValueRecursive() throws Exception {
        ExtendedHashBlob blob = new ExtendedHashBlob(0);
        int hash = ((Object)((Object)this)).hashCode();
        ClassUtils.setFieldValue((Object)blob, (String)"hash", (Object)hash, (boolean)true);
        Assert.assertThat((Object)hash, (Matcher)CoreMatchers.equalTo((Object)((HashBlob)blob).getHash()));
    }

    @Test(expected=NoSuchFieldException.class)
    public void setUnexistentFieldValueRecursive() throws Exception {
        ClassUtils.setFieldValue((Object)new ExtendedHashBlob(1), (String)"fake", (Object)0, (boolean)true);
    }

    @Test(expected=NoSuchFieldException.class)
    public void setInheritedFieldValueWithoutRecurse() throws Exception {
        ClassUtils.setFieldValue((Object)new ExtendedHashBlob(1), (String)"hash", (Object)0, (boolean)false);
    }

    @Test
    public void isInstance() {
        Assert.assertThat((Object)ClassUtils.isInstance(String.class, null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)ClassUtils.isInstance(String.class, (Object)""), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Fruit.class, (Object)new Apple()), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Apple.class, (Object)new Kiwi()), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)ClassUtils.isInstance(Integer.class, (Object)0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Integer.TYPE, (Object)0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Long.TYPE, (Object)new Long(0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Double.class, (Object)new Double(0.0)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Double.TYPE, (Object)new Double(0.0)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Boolean.TYPE, (Object)true), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Boolean.TYPE, (Object)Boolean.TRUE), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(Boolean.class, (Object)true), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ClassUtils.isInstance(String.class, (Object)true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)ClassUtils.isInstance(Long.TYPE, (Object)Boolean.FALSE), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void runWithClassLoader() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader mockClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)mockClassLoader, () -> this.assertContextClassLoader(mockClassLoader));
        this.assertContextClassLoader(originalClassLoader);
    }

    @Test
    public void returnWithClassLoader() {
        String value = "Hello World!";
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader mockClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        String response = (String)ClassUtils.withContextClassLoader((ClassLoader)mockClassLoader, () -> {
            this.assertContextClassLoader(mockClassLoader);
            return "Hello World!";
        });
        this.assertContextClassLoader(originalClassLoader);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Object)"Hello World!"));
    }

    private void assertContextClassLoader(ClassLoader mockClassLoader) {
        Assert.assertThat((Object)Thread.currentThread().getContextClassLoader(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)mockClassLoader)));
    }

    private void simpleNameHelper(String target, Class clazz) {
        Assert.assertEquals((Object)target, (Object)ClassUtils.getSimpleName((Class)clazz));
    }

    private static class ExtendedHashBlob
    extends HashBlob {
        public ExtendedHashBlob(int hash) {
            super(hash);
        }
    }

    private static class HashBlob {
        private int hash;

        public HashBlob(int hash) {
            this.hash = hash;
        }

        private int getHash() {
            return this.hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (null == other || !this.getClass().equals(other.getClass())) {
                return false;
            }
            return this.hash == ((HashBlob)other).hash;
        }
    }

    private static class DummyObject {
        private DummyObject() {
        }

        public void doSomething(Object object) {
        }

        public Object doSomethingElse(Object object) {
            return object;
        }
    }
}

