/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.CollectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CollectionUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testToStringNull() throws Exception {
        Collection c = null;
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringEmpty() throws Exception {
        ArrayList c = new ArrayList();
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringSingleElement() throws Exception {
        List<String> c = Arrays.asList("foo");
        Assert.assertEquals((Object)"[foo]", (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)("[" + SystemUtils.LINE_SEPARATOR + "foo" + SystemUtils.LINE_SEPARATOR + "]"), (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringMultipleElements() throws Exception {
        List<Serializable> c = Arrays.asList("foo", ((Object)((Object)this)).getClass());
        Assert.assertEquals((Object)("[foo, " + ((Object)((Object)this)).getClass().getName() + "]"), (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)("[" + SystemUtils.LINE_SEPARATOR + "foo" + SystemUtils.LINE_SEPARATOR + ((Object)((Object)this)).getClass().getName() + SystemUtils.LINE_SEPARATOR + "]"), (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringTooManyElements() {
        ArrayList<Integer> test = new ArrayList<Integer>(100);
        for (int i = 0; i < 100; ++i) {
            test.add(new Integer(i));
        }
        String result = CollectionUtils.toString(test, (int)10);
        Assert.assertTrue((boolean)result.endsWith("[..]]"));
        Assert.assertEquals((long)9L, (long)StringUtils.countMatches((String)result, (String)","));
    }
}

